(***************************************************************************)
(* UCompSDGroupCaracterization.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***************************************************************************)

{
@abstract(Composant caractrisation des groupes - pour dcrire les clusters par exemple)
@author(Ricco)
@created(12/01/2004)
}
unit UCompSDGroupCaracterization;

interface

USES
        Forms,
        UCompDefinition,
        UCompSDDefinition,
        UOperatorDefinition;

TYPE
        {gnrateur de composant group carac}
        TMLGenCompSDGroupCarac = class(TMLGenComp)
                                 protected
                                 procedure   GenCompInitializations(); override;
                                 public
                                 function    GetClassMLComponent: TClassMLComponent; override;
                                 end;

        {le composant group caracterization}
        TMLCompSDGroupCarac = class(TMLCompSD)
                              protected
                              function    getClassOperator: TClassOperator; override;
                              function    GetLogResultDescription(): string; override;
                              end;

        {construire les stats}
        TOpSDGroupCarac = class(TOpSD)
                          protected
                          procedure   InitializeListStat(); override;
                          function    getClassParameter: TClassOperatorParameter; override;
                          procedure   RebuildStatDes(); override;
                          function    CheckAttributes(): boolean; override;
                          public
                          end;

        {paramtrage de l'oprateur de calcul}
        TOpPrmSDGroupCarac = class(TOpPrmSD)
                             protected
                             function    CreateDlgParameters(): TForm; override;
                             procedure   SetDefaultParameters(); override;
                             public
                             function    getHTMLParameters(): string; override;
                             end;


implementation

USES
        Classes, Sysutils,
        UDatasetImplementation, UCalcStatDesGroupCaracterization,
        UCalcStatDes, UDatasetDefinition, UStringsResources;

{ TMLGenCompSDGroupCarac }

procedure TMLGenCompSDGroupCarac.GenCompInitializations;
begin
 FMLComp:= mlcDescriptiveStat;
 //FMLNumIcon:= 23;
 //FMLCompName:= str_comp_name_sd_group_caracterization;
 //FMLBitmapFileName:= 'MLSDGroupCaracterization.bmp';
end;

function TMLGenCompSDGroupCarac.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDGroupCarac; 
end;

{ TMLCompSDGroupCarac }

function TMLCompSDGroupCarac.getClassOperator: TClassOperator;
begin
 result:= TOpSDGroupCarac; 
end;

function TMLCompSDGroupCarac.GetLogResultDescription: string;
begin
 result:= Format('Description of %d continuous attributes from %d discrete one, %d examples',[(Operator as TOpSDGroupCarac).WorkData.LstAtts[asTarget].Count,
                (Operator as TOpSDGroupCarac).WorkData.LstAtts[asInput].Count,(Operator as TOpSDGroupCarac).WorkData.Examples.Size]);
end;

{ TOpPrmSDGroupCarac }

function TOpPrmSDGroupCarac.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

function TOpPrmSDGroupCarac.getHTMLParameters: string;
begin
 result:= '';
end;

procedure TOpPrmSDGroupCarac.SetDefaultParameters;
begin
 SortResult:= TRUE;
 SortCriteria:= 1;
end;

{ TOpSDGroupCarac }

function TOpSDGroupCarac.CheckAttributes: boolean;
var ok: boolean;
begin
 //vrification des target
 ok:= (self.WorkData.LstAtts[asTarget].Count > 0) and (self.WorkData.LstAtts[asTarget].isAllCategory(caDiscrete));
 //vrification des input
 ok:= ok and (self.WorkData.LstAtts[asInput].Count>0);
 //and then...
 result:= ok;
end;

function TOpSDGroupCarac.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSDGroupCarac; 
end;

procedure TOpSDGroupCarac.InitializeListStat;
begin
 FLstStat:= TLstGroupCaracterization.Create(NIL,NIL);
end;

procedure TOpSDGroupCarac.RebuildStatDes;
var stat: TGroupCaracterization;
    attY: TAttribute;
    i: integer;
begin
 //pour chaque variable  dcrire
 for i:= 0 to pred(workdata.LstAtts[asTarget].Count) do
  begin
   attY:= workdata.LstAtts[asTarget].Attribute[i];
   //le type est ok ?
   if attY.isCategory(caDiscrete)
    then
     begin
      stat:= TGroupCaracterization.Create(attY,WorkData.LstAtts[asInput]);
      FLstStat.AddStat(stat);
     end;
  end;

end;

initialization
 RegisterClass(TMLGenCompSDGroupCarac);
end.
