(***********************************************************************)
(* UCalcSDGroupExploration.pas - Copyright (c) 2006 Ricco RAKOTOMALALA *)
(***********************************************************************)

{
@abstract(Caractrisation d'un sous-ensemble d'observations, trs utile pour la classif par exemple)
@author(Ricco)
@created(09/02/2006)
}

unit UCalcSDGroupExploration;

interface

USES
    Contnrs,
    EzdslBAr,
    UDatasetDefinition,
    UDatasetImplementation,
    UDatasetExamples,
    UCalcStatDesGroupCaracterization,
    UCalcStatDes;

TYPE
    //**************************************************************************
    //classe de recensement des individus associs  une modalit d'une variable
    //**************************************************************************
    TCoverValueAtt = class
    private
    FAttribute: TAttDiscrete;//attribut
    FValue: TTypeDiscrete;//valeur associe
    FBoolValues: TBooleanArray;//tableau des valeurs recenses
    //affecter une valeur  l'observation ni
    procedure   setValue(i: integer; const value: boolean);
    function    getValue(i: integer): boolean;
    public
    constructor create(att: TAttribute; k: TTypeDiscrete);
    destructor  destroy(); override;
    //mettre tout le monde  false
    procedure   resetToFalse();
    //recompter les prsentes
    procedure   refreshCount();
    //
    property    value[i: integer]: boolean read getValue write setValue;
    property    boolValues: TBooleanArray read FBoolValues;
    end; 
    
    //**************************************************************************
    //classe de recensement des individus associs  chaque modalit d'un attribut
    //ne fonctionne qu'avec des attributs discrets
    //**************************************************************************
    TCoverDiscreteAttribute = class
    private
    //attribut
    FAttribute: TAttDiscrete;
    //liste des lments associs  chaque modalit -- liste propritaire de "boolean array"
    FLstValues: TObjectList;
    //recalculer les listes
    procedure   refreshValues(prmExamples: TExamples);
    public
    constructor create(att: TAttribute; prmExamples: TExamples = nil);
    destructor  destroy(); override;
    //rcuprer la boolean array de la valeur k de l'attribut
    function    getCovAttValue(k: integer): TCoverValueAtt;
    //nombre de valeurs associ
    function    getNbValues(): integer;
    //
    property    Attribute: TAttDiscrete read FAttribute;
    end;

    //**************************************************************************
    //liste de ci-dessus - une liste d'attributs INPUT a priori
    //**************************************************************************
    TLstCovDiscAttribute = class
    private
    //liste propritaire
    FLstCovAtt: TObjectList;
    //recalcul
    //procedure   refreshLst(prmExamples: TExamples);
    public
    constructor create(lstAtt: TLstAttributes; prmExamples: TExamples = nil);
    destructor  destroy(); override;
    //nombre de variables recenses
    function    getCount(): integer;
    //la variable recense nj
    function    getCovAtt(j: integer): TCoverDiscreteAttribute;
    end;

    //**************************************************************************
    //caractrisation d'un noeud de l'arbre d'exploration
    //**************************************************************************
    TNodeGroupExploration = class
    private
    //les stats descriptives conditionnelles
    FStatGroup: TLstGroupAttCarac;
    //tableau interne des individus couverts
    FBoolCovered: TBooleanArray;
    //Attribut
    FAttribute: TAttribute;
    //valeur associe
    FValue: TTypeDiscrete;
    public
    constructor create(att: TAttribute; value: TTypeDiscrete; lstTarget: TLstAttributes; statGlob: TLstCalcStatDes; attRule: TAttribute; valueRule: TTypeDiscrete);
    destructor  destroy(); override;
    //connecter les deux noeuds, noeud pre et attribut de caractrisation --> lance les calculs locaux
    procedure   connectingNodes(pere,carac: TBooleanArray);
    //rcuprer les individus couverts
    function    getCovered(): TBooleanArray;
    //nombre d'exemples couverts
    function    getNbExamples(): integer;
    //envoyer les infos en HTML
    function    getHTML(): string;
    //envoyer la description de la rgle
    function    getRuleDescription(): string;
    end;

implementation

uses
    Sysutils;

{ TCoverDiscreteAttribute }

constructor TCoverDiscreteAttribute.create(att: TAttribute;
  prmExamples: TExamples);
var k: integer;
begin
 inherited create();
 FAttribute:= att as TAttDiscrete;
 FLstValues:= TObjectList.Create(TRUE);
 for k:= 1 to att.nbValues do
  FLstValues.Add(TCoverValueAtt.create(att,k));
 if (prmExamples <> nil)
  then self.refreshValues(prmExamples);
end;

destructor TCoverDiscreteAttribute.destroy;
begin
 FLstValues.Free();
 inherited;
end;


function TCoverDiscreteAttribute.getCovAttValue(
  k: integer): TCoverValueAtt;
begin
 //pas de contrle
 result:= FLstValues.Items[k] as TCoverValueAtt; 
end;

function TCoverDiscreteAttribute.getNbValues: integer;
begin
 result:= FLstValues.Count;
end;

procedure TCoverDiscreteAttribute.refreshValues(prmExamples: TExamples);
var k,i,example: integer;
begin
 for k:= 0 to pred(FLstValues.Count) do
  self.getCovAttValue(k).resetToFalse();
 //puis tester chaque individu
 for i:= 1 to prmExamples.Size do
  begin
   example:= prmExamples.Number[i];
   k:= FAttribute.dValue[example];
   self.getCovAttValue(pred(k)).setValue(example,TRUE);
  end;
 //mj les compteurs
 for k:= 0 to pred(FLstValues.Count) do
  self.getCovAttValue(k).refreshCount();
end;

{ TCoverValueAtt }

constructor TCoverValueAtt.create(att: TAttribute; k: TTypeDiscrete);
begin
 inherited create();
 FAttribute:= att as TAttDiscrete;
 FValue:= k;
 FBoolValues:= TBooleanArray.Create(att.Size+1);
end;

destructor TCoverValueAtt.destroy;
begin
 FBoolValues.Free();
 inherited;
end;

function TCoverValueAtt.getValue(i: integer): boolean;
begin
 //pas de contrle, on va au plus rapide
 result:= FBoolValues.Flag[i];
end;

procedure TCoverValueAtt.refreshCount;
begin
 FBoolValues.RefreshCount();
end;

procedure TCoverValueAtt.resetToFalse;
begin
 FBoolValues.SetAllFalse();
end;

procedure TCoverValueAtt.setValue(i: integer; const value: boolean);
begin
 FBoolValues.Flag[i]:= value;
end;

{ TLstCovDiscAttribute }

constructor TLstCovDiscAttribute.create(lstAtt: TLstAttributes;
  prmExamples: TExamples);
var j: integer;
begin
 inherited create();
 FLstCovAtt:= TObjectList.Create(TRUE);
 for j:= 0 to pred(lstAtt.Count) do
  FLstCovAtt.Add(TCoverDiscreteAttribute.create(lstAtt.Attribute[j],prmExamples));
end;

destructor TLstCovDiscAttribute.destroy;
begin
 FLstCovAtt.Free();
 inherited;
end;

function TLstCovDiscAttribute.getCount: integer;
begin
 result:= FLstCovAtt.Count;
end;

function TLstCovDiscAttribute.getCovAtt(
  j: integer): TCoverDiscreteAttribute;
begin
 result:= FLstCovAtt.Items[j] as TCoverDiscreteAttribute;
end;

(*
procedure TLstCovDiscAttribute.refreshLst(prmExamples: TExamples);
var j: integer;
begin
 for j:= 0 to pred(FLstCovAtt.Count) do
  (FLstCovAtt.Items[j] as TCoverDiscreteAttribute).refreshValues(prmExamples);
end;
*)

{ TNodeGroupExploration }

procedure TNodeGroupExploration.connectingNodes(pere,
  carac: TBooleanArray);
var i: integer;
    ex: TExamples;
begin
 FBoolCovered.CopyFrom(pere);
 FBoolCovered.AndArray(carac);
 FBoolCovered.RefreshCount();
 //construire la liste locale des individus
 ex:= TExamples.Create(FBoolCovered.Count);
 ex.BeginAdd();
 for i:= 1 to pred(FBoolCovered.Capacity) do
  if FBoolCovered.Flag[i] then ex.AddExample(i);
 ex.EndAdd();
 //calculer les stats. locales
 FStatGroup.Refresh(ex);
 FStatGroup.ComputeStats();
 FStatGroup.SortList(1);//sur la V-TEST
 //et vider tout a
 ex.Free();
end;

constructor TNodeGroupExploration.create(att: TAttribute; value: TTypeDiscrete;
lstTarget: TLstAttributes; statGlob: TLstCalcStatDes; attRule: TAttribute; valueRule: TTypeDiscrete);
begin
  inherited create();
  FAttribute:= attRule;
  FValue:= valueRule;
  FStatGroup:= TLstGroupAttCarac.Create(att,value,lstTarget,statGlob);
  FBoolCovered:= TBooleanArray.Create(succ(att.Size)); 
end;

destructor TNodeGroupExploration.destroy;
begin
  FBoolCovered.Free();
  FStatGroup.Free();
  inherited;
end;

function TNodeGroupExploration.getCovered: TBooleanArray;
begin
 result:= FBoolCovered;
end;

function TNodeGroupExploration.getHTML: string;
begin
 result:= FStatGroup.getHTMLResult();
end;

function TNodeGroupExploration.getNbExamples: integer;
begin
 result:= FBoolCovered.Count;
end;

function TNodeGroupExploration.getRuleDescription: string;
begin
 result:= format('%s = %s',[FAttribute.Name,FAttribute.LstValues.getDescription(FValue)]);
end;

end.
