(***********************************************************************)
(* UCompSDGroupExploration.pas - Copyright (c) 2006 Ricco RAKOTOMALALA *)
(***********************************************************************)

{
@abstract(Exploration de sous-groupes d'individus)
@author(Ricco)
@created(09/02/2006)

Il s'agit surtout d'explorer les possibilits du composant TVirtualTreeView !


}
unit UCompSDGroupExploration;

interface

USES
        Forms,
        UCompDefinition,
        UCompManageDataset,
        UOperatorDefinition,
        UDatasetImplementation,
        UCalcSDGroupExploration,
        UCalcStatDes;

TYPE
        {Gnrateur de composant de visualisation}
        TMLGenCompGroupExploration = class(TMLGenComp)
                             protected
                             procedure   GenCompInitializations(); override;
                             public
                             function    GetClassMLComponent: TClassMLComponent; override;   
                             end;

        {le composant de visualisation}
        TMLCompGroupExploration = class(TMLCompLocalData)
                          protected
                          function    getClassOperator: TClassOperator; override;
                          end;

        {l'oprateur de visualisation}
        TOpGroupExploration = class(TOpLocalData)
                      private
                      //liste des attributs inputs et des couvertures par modalit
                      FLstCovAtt: TLstCovDiscAttribute;
                      //les statistiques descriptives sur la racine (pour les input)
                      FLstStatInput: TLstCalcStatDes;
                      protected
                      function    getClassParameter: TClassOperatorParameter; override;
                      function    getNewForm(): TForm; override;
                      function    CheckAttributes(): boolean; override;
                      {pas de lancement de calcul ici}
                      function    CoreExecute(): boolean; override;
                      public
                      destructor  destroy(); override;
                      function    getHTMLResultsSummary(): string; override;
                      property    lstCovAtt: TLstCovDiscAttribute read FLstCovAtt;
                      property    lstStatInput: TLstCalcStatDes read FLstStatInput;
                      end;

        {paramtrage de l'oprateur de visualisation}
        TOpPrmGroupExploration = class(TOperatorParameter)
                         private
                         protected
                         procedure   SetDefaultParameters(); override;
                         function    CreateDlgParameters(): TForm; override;
                         end;


implementation

uses
    Sysutils,
    Classes, UFrmOpViewSDGroupExploration, UDatasetDefinition;

{ TMLGenCompGroupExploration }

procedure TMLGenCompGroupExploration.GenCompInitializations;
begin
 FMLComp:= mlcDescriptiveStat;
end;

function TMLGenCompGroupExploration.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompGroupExploration;
end;

{ TMLCompGroupExploration }

function TMLCompGroupExploration.getClassOperator: TClassOperator;
begin
 result:= TOpGroupExploration;
end;

{ TOpGroupExploration }

function TOpGroupExploration.CheckAttributes: boolean;
begin
 result:= (self.WorkData.LstAtts[asInput].Count > 0)
          and ((self.WorkData.LstAtts[asTarget].Count > 0) and self.WorkData.LstAtts[asTarget].isAllCategory(caDiscrete));
end;

function TOpGroupExploration.CoreExecute: boolean;
begin
 if assigned(FLstCovAtt) then FLstCovAtt.Free();
 if assigned(FLstStatInput) then FLstStatInput.Free(); 
 TRY
 //reconstruire toute la liste des couvertures pour les TARGET
 FLstCovAtt:= TLstCovDiscAttribute.create(self.WorkData.LstAtts[asTarget],self.WorkData.Examples);
 //calculer toutes les stats. des. sur la racine
 FLstStatInput:= TLstCalcStatDes.Create(self.WorkData.LstAtts[asInput],self.WorkData.Examples);
 //
 result:= TRUE;
 EXCEPT
 result:= FALSE;
 END;
end;

destructor TOpGroupExploration.destroy;
begin
 if assigned(FLstStatInput) then FreeAndNil(FLstStatInput);
 if assigned(FLstCovAtt) then FreeAndNil(FLstCovAtt);
 inherited;
end;

function TOpGroupExploration.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmGroupExploration;
end;

function TOpGroupExploration.getHTMLResultsSummary: string;
begin
 result:= format('Root node : <b>%d</b> examples, <b>%d</b> target attributes',[self.WorkData.Examples.Size,self.WorkData.LstAtts[asTarget].Count]);
end;

function TOpGroupExploration.getNewForm: TForm;
begin
 result:= TfrmOpViewSDGroupExploration.CreateFromOperator(self);
end;

{ TOpPrmGroupExploration }

function TOpPrmGroupExploration.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

procedure TOpPrmGroupExploration.SetDefaultParameters;
begin
 //none...
end;

initialization
 RegisterClass(TMLGenCompGroupExploration);
end.
