unit UFrmOpViewSDGroupExploration;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBaseOperator, Menus, ActnList, ComCtrls, ExtCtrls, StdCtrls,
  UCompSDGroupExploration, HTMLLite, UDatasetDefinition, EzdslBAr;

type
  TfrmOpViewSDGroupExploration = class(TFrmBaseOperator)
    TabSDGroupExploration: TTabSheet;
    Panel2: TPanel;
    Panel3: TPanel;
    Splitter3: TSplitter;
    panelGroupDescription: TPanel;
    panelHTML: TPanel;
    Panel1: TPanel;
    Splitter2: TSplitter;
    Panel6: TPanel;
    lstInput: TListBox;
    Panel8: TPanel;
    Panel7: TPanel;
    Panel9: TPanel;
    tvGroup: TTreeView;
    Splitter1: TSplitter;
    PopupMenu1: TPopupMenu;
    Delete1: TMenuItem;
    Deleteleaves1: TMenuItem;
    procedure tvGroupDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure tvGroupDeletion(Sender: TObject; Node: TTreeNode);
    procedure tvGroupDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure tvGroupClick(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure actCopyExecute(Sender: TObject);
    procedure Deleteleaves1Click(Sender: TObject);
  private
    { Dclarations prives }
    //composants de visualisation
    viewHtml: THTMLLite;
    //chane de cat. courante dans le viewer
    curString: string;
    //operateur de calcul
    opGroupExplore: TOpGroupExploration;
    //un attribut fictif. qui reprsente la modalit " caractriser" --> le but est de dtourner "Group characterization"
    attCar: TAttribute;
    //tableau des individus sur la racine
    boolRoot: TBooleanArray;
  public
    { Dclarations publiques }
    procedure   PrepareView(); override;
    destructor  Destroy(); override;
  end;

var
  frmOpViewSDGroupExploration: TfrmOpViewSDGroupExploration;

implementation

uses
    Clipbrd,
    UCalcSDGroupExploration, UCompDefinition, UDatasetImplementation,
    UConstConfiguration;

{$R *.dfm}

{ TfrmOpViewSDGroupExploration }



destructor TfrmOpViewSDGroupExploration.Destroy;
begin
  if (attCar <> nil) then attCar.Free();
  //if (boolRoot <> nil) then boolRoot.Free(); --> pas ncessaire parce qu'il est associ  un neoud qui lui se dtruit en interne
  inherited;
end;

procedure TfrmOpViewSDGroupExploration.PrepareView;
var i,j: integer;
    attCov: TCoverDiscreteAttribute;
begin
 inherited;

 //rcuprer l'oprateur de calcul
 opGroupExplore:= Operator as TOpGroupExploration;

 //former l'attribut "feinte"  caractriser pour pouvoir utiliser les classes de calcul
 //de "group characterization"

 if (attCar <> nil) then attCar.Free();
 attCar:= TAttDiscrete.Create('Subgroup ',opGroupExplore.WorkData.LstAtts[asInput].Size);
 attCar.LstValues.getValue(' Local');

 //crer le tableau des donnes sur le noeud racine
 boolRoot:= TBooleanArray.Create(succ(attCar.Size));
 boolRoot.SetAllFalse();
 for i:= 1 to opGroupExplore.WorkData.Examples.Size do
  boolRoot.Flag[opGroupExplore.WorkData.Examples.Number[i]]:= TRUE;

 //********************************************//
 //intgrer les composants visuels  afficher *//
 //********************************************//

 //lister les variables INPUT associes aux couvertures
 lstInput.Items.Clear();
 for j:= 0 to pred(opGroupExplore.lstCovAtt.getCount()) do
  begin
   attCov:= opGroupExplore.lstCovAtt.getCovAtt(j);
   lstInput.Items.AddObject(format('(%3d) %s',[attCov.getNbValues(),attCov.Attribute.Name]),attCov);
  end;

 //afficher le nombre total d'exemples dans la racine et la slectionner
 tvGroup.Items[0].Text:= format('Root (%d examples)',[opGroupExplore.WorkData.Examples.Size]);
 tvGroup.Select(tvGroup.Items[0]);
 //affecter les individus totaux
 tvGroup.Items[0].Data:= boolRoot;

 //composant HTML
 viewHTML:= THTMLLite.Create(panelHTML);
 viewHTML.Parent:= panelHTML;

 viewHTML.Align:= alClient;
 viewHTML.DefBackground:= clWhite;

 //faire afficher les stats. descriptives de la racine
 curString:= (opGroupExplore.MLOwner as TMLComponent).getHTMLDescriptionContents();
 viewHTML.LoadFromString(curString,'');

end;

procedure TfrmOpViewSDGroupExploration.tvGroupDragOver(Sender,
  Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
var node: TTreeNode;
begin
 //tester si la source est la TListBox
 if (Source is TListbox)
  then
   begin
    //rcuprer le noeud dsign
    node:= tvGroup.GetNodeAt(X,Y);
    if (node <> nil)
     then accept:= true;
   end
  else accept:= false;
end;

procedure TfrmOpViewSDGroupExploration.tvGroupDeletion(Sender: TObject;
  Node: TTreeNode);
begin
 //librer l'objet point, le cas chant
 if (node.Data <> NIL)
  then
   begin
    TObject(node.Data).Free();
    node.Data:= NIL;
   end;
end;

procedure TfrmOpViewSDGroupExploration.tvGroupDragDrop(Sender,
  Source: TObject; X, Y: Integer);
var curNode,leafNode: TTreeNode;
    nodeInfo: TNodeGroupExploration;
    attCov: TCoverDiscreteAttribute;
    src: TListBox;
    k: integer;
    boolCov: TBooleanArray;
begin
 //tester si la source est la TListBox
 if (Source is TListbox)
  then
   begin
    //rcuprer l'lment source
    src:= Source as TListBox;
    {$B-}
    if (src.ItemIndex >= 0)
     then
      begin
       attCov:= src.Items.Objects[src.ItemIndex] as TCoverDiscreteAttribute;
       //rcuprer le noeud dsign
       curNode:= tvGroup.GetNodeAt(X,Y);
       if (curNode <> nil) and (attCov <> nil)
        then
         begin
          //rcuprer le tableau de boolen du noeud
          if (curNode = tvGroup.Items[0])
           then boolCov:= self.boolRoot
           else boolCov:= TNodeGroupExploration(curNode.Data).getCovered();
          //pour chaque modalit de l'attribut de groupement
          for k:= 1 to attCov.getNbValues() do
           begin
            //calculer les infos pour le nouveau neoud
            nodeInfo:= TNodeGroupExploration.create(self.attCar,1,opGroupExplore.WorkData.LstAtts[asInput],opGroupExplore.lstStatInput,attCov.Attribute,k);
            nodeInfo.connectingNodes(boolCov,attCov.getCovAttValue(pred(k)).boolValues);
            //crer le noeud "visuel"
            leafNode:= self.tvGroup.Items.AddChild(curNode,format('%s = %s (%d ex.)',[attCov.Attribute.Name,attCov.Attribute.LstValues.getDescription(k),nodeInfo.getNbExamples()]));
            //connecter les infos au noeud visuel
            leafNode.Data:= nodeInfo;
           end;
          //dvelopper
          curNode.Expand(TRUE);
         end;
      end;
   end;
end;

procedure TfrmOpViewSDGroupExploration.tvGroupClick(Sender: TObject);
var curInfo,info: TNodeGroupExploration;
    rule: string;
    predNode: TTreeNode;
begin
 //vrifier qu'un noeud est slectionn
 if (tvGroup.Selected <> nil)
  then
   begin
    if (tvGroup.Selected = tvGroup.Items[0])
     then
      begin
       curString:= (opGroupExplore.MLOwner as TMLComponent).getHTMLDescriptionContents();
       viewHTML.LoadFromString(curString,'');
      end
     else
      begin
       curInfo:= TNodeGroupExploration(tvGroup.Selected.Data);
       //former la rgle de description du groupe
       predNode:= tvGroup.Selected;
       rule:= '';
       while (predNode <> tvGroup.Items[0]) do
        begin
         info:= TNodeGroupExploration(predNode.Data);
         rule:= info.getRuleDescription() + ' && ' + rule;
         predNode:= predNode.Parent;
        end;
       delete(rule,length(rule)-3,4);
       //former la chane de description
       curString:= '<HTML><HEAD>'+HTML_REPORT_CLASS_STYLE+'</HEAD>';
       curString:= curString + '<BODY class="BodyStyle">';
       curString:= curString + HTML_REPORT_FONT_STYLE;
       curString:= curString + format('<b>Rule : </b>%s<HR>',[rule]);
       curString:= curString + curInfo.getHTML();
       curString:= curString + '<HR>';
       curString:= curString + '</body></html>';
       //envoyer le tout
       viewHTML.LoadFromString(curString,'');
      end;
   end;

end;

procedure TfrmOpViewSDGroupExploration.Delete1Click(Sender: TObject);
begin
 if (tvGroup.Selected <> nil) and (tvGroup.Selected <> tvGroup.Items[0])
  then tvGroup.Selected.Delete();
end;

procedure TfrmOpViewSDGroupExploration.actCopyExecute(Sender: TObject);
var curClipBrd: TClipBoard;
begin
 //envoyer la chane de rsultats dans le clipboard
 curClipBrd:= ClipBoard();
 TRY
 curClipBrd.Open();
 curClipbrd.AsText:= curString;
 FINALLY
 curClipBrd.Close();
 END;
end;

procedure TfrmOpViewSDGroupExploration.Deleteleaves1Click(Sender: TObject);
begin
 if (tvGroup.Selected <> nil)
  then tvGroup.Selected.DeleteChildren();
end;

end.
