(*************************************************************************)
(* UCompSDKRelatedDefinition.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(*************************************************************************)

{
@abstract(composant de base pour les comparaisons de populations sur K-chantillons apparis)
@author(Ricco)
@created(04/05/2005)

Permet de remonter  un niveau plus gnrique le contrle des attributs et l'appel
des classes de calcul.

Contrairement au prfixe, ce ne sont pas de classes hritire de SD. Mais
nous les classons dans cette catgorie "mthodologiquement". C'est compliqu quoi !
}

unit UCompSDKRelatedDefinition;

interface

USES
    Forms,
    UCompDefinition,
    UCompManageDataset,
    UOperatorDefinition,
    UDatasetDefinition,
    UCalcStatDesKRelatedSamples;

TYPE
    //rien de particulier -- transmission
    TMLCompSDKRelated = class(TMLCompLocalData)
                        end;

    //oprateur de calcul
    TOpSDKRelated = class(TOpLocalData)
                    protected
                    //instance de calcul
                    FCalc: TCalcSDKRelated;
                    //crer une instance de calcul
                    //!\c'est ici qu'on jouera selon les paramtres pour la concordance de Kendall
                    function    getCalcInstance(lstAtts: TLstAttributes): TCalcSDKRelated; virtual; abstract;
                    //excution
                    function    CoreExecute(): boolean; override;
                    //attributs tous continus et le nombre doit tre suprieur  1
                    function    CheckAttributes(): boolean; override;
                    public
                    {envoyer le rapport au format standard, i.e. tableaux de rsultats}
                    function    getHTMLResultsSummary(): string; override;
                    end;

    //paramtrage de l'oprateur
    TOpPrmSDKRelated = class(TOperatorParameter)
                       protected
                       function    CreateDlgParameters(): TForm; override;
                       procedure   SetDefaultParameters(); override;
                       end;


implementation

USES
    UDatasetImplementation;

{ TOpSDKRelated }

function TOpSDKRelated.CheckAttributes: boolean;
begin
 result:= (self.WorkData.LstAtts[asInput].Count > 1) and self.WorkData.LstAtts[asInput].isAllCategory(caContinue);
end;

function TOpSDKRelated.CoreExecute: boolean;
begin
 TRY
 result:= TRUE;
 if (FCalc <> nil) then FCalc.Free();
 //crer une nouvelle instance de calcul
 FCalc:= getCalcInstance(self.WorkData.LstAtts[asInput]);
 //et lancer les calculs
 FCalc.computeStats(self.WorkData.Examples);
 EXCEPT
 result:= FALSE;
 END;
end;

function TOpSDKRelated.getHTMLResultsSummary: string;
begin
 result:= FCalc.getHTMLResults();
end;

{ TOpPrmSDKRelated }

function TOpPrmSDKRelated.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

procedure TOpPrmSDKRelated.SetDefaultParameters;
begin
 //none
end;

end.
