(********************************************************************)
(* UCompSDKruskalWallis.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(********************************************************************)

{
@abstract(Comparaison de populations, mais avec une approche non paramtrique, celle de Kruskal-Wallis)
@author(Ricco)
@created(12/01/2004)
}
unit UCompSDKruskalWallis;

interface

USES
        Forms,
        UCompDefinition,
        UCompManageDataset,
        UCompSDDefinition,
        UCompSDCondDescDefinition,
        UOperatorDefinition,
        UDatasetDefinition,
        UDatasetImplementation,
        UCalcStatDesConditionnalDesc; 

TYPE

        {gnrateur de composant one-way anova}
        TMLGenCompSDKWallis = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

        {le composant one anova}
        TMLCompSDKWallis = class(TMLCompSD)
                            protected
                            function    getClassOperator: TClassOperator; override;
                            end;

        {oprateur de calcul }
        TOpSDKWallis = class(TOpSDCondDescDefinition)
                        protected
                        function    getClassStat(): TClassCalcSDCondDesc; override;
                        function    getClassLstStat(): TClassLstCalcStatDesCond; override;
                        function    getClassParameter: TClassOperatorParameter; override;
                        end;

        {paramtrage de l'oprateur de calcul}
        TOpPrmSDKWallis = class(TOpPrmSDCondDescDefinition)
                           end;

implementation

USES
        Classes, Sysutils, UStringAddBuffered,
        UCalcStatDes, UConstConfiguration, UStringsResources;

{ TMLGenCompSDKWallis }

procedure TMLGenCompSDKWallis.GenCompInitializations;
begin
 FMLComp:= mlcNonParametricStatistics;
end;

function TMLGenCompSDKWallis.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDKWallis;
end;

{ TMLCompSDKWallis }

function TMLCompSDKWallis.getClassOperator: TClassOperator;
begin
 result:= TOpSDKWallis;
end;

{ TOpSDKWallis }

function TOpSDKWallis.getClassLstStat: TClassLstCalcStatDesCond;
begin
 result:= TLstCalcStatDesCondKW;
end;

function TOpSDKWallis.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSDKWallis;
end;

function TOpSDKWallis.getClassStat: TClassCalcSDCondDesc;
begin
 result:= TCalcSDNonParamCondDesc;
end;

initialization
 RegisterClass(TMLGenCompSDKWallis);
end.
