(*******************************************************************)
(* UCompSDMoodRunsTest.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*******************************************************************)

{
@abstract(Comparaison de populations, mais avec une approche non paramtrique, celle de Mood)
@author(Ricco)
@created(17/07/2005)

A noter que Mood est une gnralisation au cas k-populations du test de Wald & Wolfowitz (2 population).
Attention, nous utilisons les rangs alatoires dans le cas des ex-aequos dans cette implmentation.

}

unit UCompSDMoodRunsTest;

interface

USES
   UCompDefinition, UOperatorDefinition,
   UCompSDCondDescDefinition,
   UCalcStatDesConditionnalDesc;

TYPE
   //gnrateur
   TMLGenCompSDMoodRunsTest = class(TMLGenComp)
                              protected
                              procedure   GenCompInitializations(); override;
                              public
                              function    GetClassMLComponent: TClassMLComponent; override;
                              end;

   //composant
   TMLCompSDMoodRunsTest = class(TMLCompSDCondDescDefinition)
                           protected
                           function    getClassOperator: TClassOperator; override;
                           end;

   //oprateur
   TOpSDMoodRunsTest = class(TOpSDCondDescDefinition)
                       protected
                       function    getClassStat(): TClassCalcSDCondDesc; override;
                       function    getClassLstStat(): TClassLstCalcStatDesCond; override;
                       function    getClassParameter: TClassOperatorParameter; override;
                       end;

   //paramtrage
   TOpSDPrmMoodRunsTest = class(TOpPrmSDCondDescDefinition)
                          end;

implementation

USES
   Classes, Sysutils,
   UDatasetDefinition, UDatasetImplementation,
   UCalcStatDesCondDescRuns;

{ TMLGenCompSDMoodRunsTest }

procedure TMLGenCompSDMoodRunsTest.GenCompInitializations;
begin
 FMLComp:= mlcNonParametricStatistics;
end;

function TMLGenCompSDMoodRunsTest.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDMoodRunsTest;
end;

{ TMLCompSDMoodRunsTest }

function TMLCompSDMoodRunsTest.getClassOperator: TClassOperator;
begin
 result:= TOpSDMoodRunsTest; 
end;

{ TOpSDMoodRunsTest }

function TOpSDMoodRunsTest.getClassLstStat: TClassLstCalcStatDesCond;
begin
 result:= TLstCalcStatDesCondRuns;
end;

function TOpSDMoodRunsTest.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpSDPrmMoodRunsTest; 
end;

function TOpSDMoodRunsTest.getClassStat: TClassCalcSDCondDesc;
begin
 result:= TCalcSDRunsCondDesc;
end;

initialization
 RegisterClass(TMLGenCompSDMoodRunsTest);
end.
