(************************************************************************)
(* UCompSDLinearCorrelation.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************************)

{
@abstract(Composant corrlations croises)
@author(Ricco)
@created(12/01/2004)
Ce composant est trs proche de fonctionnement du composant tableaux croiss, sans nanmoins le
mcanisme de mise en highlight de contributions, il est donc plus simple  implmenter (cf. UnivariateContinuousAtt).

new -- 01/04/2005 -- la corrlation peut maintenant tre calcule directement sur des donnes discrtes binaires (codes 1/2 en interne)
}
unit UCompSDLinearCorrelation;

interface

USES
        Forms,Classes,
        IniFiles,
        UCompDefinition,
        UCompSDDefinition,
        UOperatorDefinition,
        UCalcStatDesCorrelation;

TYPE
        {Gnrateur de univariate stat cont desc}
        TMLGenCompSDCorrelation = class(TMLGenComp)
                                  protected
                                  procedure   GenCompInitializations(); override;
                                  public
                                  function    GetClassMLComponent: TClassMLComponent; override;
                                  end;

        {le composant}
        TMLCompSDCorrelation = class(TMLCompSD)
                               protected
                               function    getClassOperator: TClassOperator; override;
                               function    GetLogResultDescription(): string; override;
                               end;

        {l'oprateur associ}
        TOpSDCorrelation     = class(TOpSD)
                               protected
                               procedure   InitializeListStat(); override;
                               function    getClassParameter: TClassOperatorParameter; override;
                               //new -- 15/07/2005 -- envoyer la class de calcul des corrlation --  surcharger imprativement
                               function    getClassCorrelation(): TClassCalcSDCorrelation; virtual;
                               //new -- 15/07/2005 -- adapt  la fonction ci-dessus, non surcharg donc chez les hritiers
                               procedure   RebuildStatDes(); override;
                               function    CheckAttributes(): boolean; override;
                               public
                               end;

        {paramtrage d'oprateur tableaux croiss}
        TOpPrmSDCorrelation = class(TOpPrmSD)
                              private
                              {Type de liste de variables en entre : 0 - double liste (target/input), 1 - simple liste (input)  croiser}
                              FInputList: Byte;
                              protected
                              function    CreateDlgParameters(): TForm; override;
                              procedure   SetDefaultParameters(); override;
                              public
                              procedure   LoadFromStream(prmStream: TStream); override;
                              procedure   SaveToStream(prmStream: TStream); override;
                              procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                              procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                              {#ToDo1 - envoyer la description des paramtres}
                              function    getHTMLParameters(): string; override;
                              property    InputList: Byte read FInputList write FInputList;
                              end;


implementation

uses
        Sysutils, UDatasetDefinition,
  UDatasetImplementation, UDlgOpPrmSDLinearCorrelation, UStringsResources,
  UConstConfiguration;

{ TMLGenCompSDCorrelation }

procedure TMLGenCompSDCorrelation.GenCompInitializations;
begin
 FMLComp:= mlcDescriptiveStat;
end;

function TMLGenCompSDCorrelation.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDCorrelation; 
end;

{ TMLCompSDCorrelation }

function TMLCompSDCorrelation.getClassOperator: TClassOperator;
begin
 result:= TOpSDCorrelation;
end;

function TMLCompSDCorrelation.GetLogResultDescription: string;
begin
 result:= format('%d correlation(s) computed on %d examples',[(Operator as TOpSD).LstStat.Count,(Operator as TOpSD).Workdata.Examples.Size]);
end;

{ TOpSDCorrelation }

function TOpSDCorrelation.CheckAttributes: boolean;
var ok: boolean;
begin
 ok:= TRUE;
 case (self.PrmOp as TOpPrmSDCorrelation).InputList of
  //target x input
  0: begin
      ok:= ok and (self.WorkData.LstAtts[asTarget].Count>0) and (self.WorkData.LstAtts[asTarget].isAllCategory(caQuasiContinue));
      ok:= ok and (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caQuasiContinue));
     end;
  //cross-input
  1 : begin
       ok:= ok and (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caQuasiContinue));
      end;
 end;
 result:= ok;
end;

function TOpSDCorrelation.getClassCorrelation: TClassCalcSDCorrelation;
begin
 result:= TCalcSDCorrelation;
end;

function TOpSDCorrelation.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSDCorrelation;
end;

procedure TOpSDCorrelation.InitializeListStat;
begin
 FLstStat:= TLstCalcSDCorrelation.Create(nil,nil);
end;

procedure TOpSDCorrelation.RebuildStatDes;
var stat: TCalcSDCorrelation;
    attI,attJ: TAttribute;
    i,j: integer;
begin
 case (PrmOp as TOpPrmSDCorrelation).FInputList of
  //double liste target-input
  0: begin
       //pour chaque variable de description
       for i:= 0 to pred(workdata.LstAtts[asTarget].Count) do
        begin
         attI:= workdata.LstAtts[asTarget].Attribute[i];
         //le type est ok ?
         if attI.isCategory(caQuasiContinue)
          then
           begin
            //les variables  dcrire
            for j:= 0 to pred(WorkData.LstAtts[asInput].Count) do
             begin
              attJ:= WorkData.LstAtts[asInput].Attribute[j];
              //petit test quand mme
              if attJ.isCategory(caQuasiContinue) and (attI<>attJ)
               then
                begin
                 stat:= getClassCorrelation().Create(attI,attJ,nil);
                 self.LstStat.AddStat(stat);
                end;
             end;
           end;
        end;
     end
  else
   //simple liste input  croiser
   begin
    for i:= 0 to WorkData.LstAtts[asInput].Count-2 do
     begin
      attI:= workdata.LstAtts[asInput].Attribute[i];
      if attI.isCategory(caQuasiContinue)
       then
        begin
          for j:= succ(i) to pred(WorkData.LstAtts[asInput].Count) do
           begin
            attJ:= WorkData.LstAtts[asInput].Attribute[j];
            //le deuxime test renvoie toujours vrai sinon il y a un srieux problme
            if attJ.isCategory(caQuasiContinue) and (attJ<>attI)
             then
              begin
               stat:= getClassCorrelation().Create(attI,attJ,nil);
               self.LstStat.AddStat(stat);
              end;
           end;
        end;
     end;
   end;
 end;
end;

{ TOpPrmSDCorrelation }

function TOpPrmSDCorrelation.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmLinearCorrelation.CreateFromOpPrm(self);
end;

function TOpPrmSDCorrelation.getHTMLParameters: string;
var s,sPrm: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>Cross-tab parameters</TH></TR>';
 if self.SortResult
  then sPrm:= 'yes'
  else sPrm:= 'non';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Sort results</TD><TD align="right">%s</TD></TR>',[sPrm]);
 if self.SortResult
  then
   begin
    case self.SortCriteria of
     0: sPrm:= 'Y attribute name';
     1: sPrm:= 'X attribute name';
     2: sPrm:= 'r statistic';
     3: sPrm:= '|r| statistic';
    end;
    s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Sort criterion</TD><TD align="right">%s</TD></TR>',[sPrm]);
   end;
 if (self.InputList=0)
  then sPrm:= 'Target (Y) and input (X)'
  else sPrm:= 'Cross-input (Y x X)';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Input list</TD><TD align="right">%s</TD></TR>',[sPrm]);
 s:= s+'</table>';
 //and then...
 result:= s;
end;

procedure TOpPrmSDCorrelation.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 inherited LoadFromINI(prmSection,prmINI);
 FInputList:= prmINI.ReadInteger(prmSection,'input_list',FInputList);
end;

procedure TOpPrmSDCorrelation.LoadFromStream(prmStream: TStream);
begin
 inherited LoadFromStream(prmStream);
 prmStream.ReadBuffer(FInputList,sizeOf(FInputList));
end;

procedure TOpPrmSDCorrelation.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 inherited SaveToINI(prmSection,prmINI);
 prmINI.WriteInteger(prmSection,'input_list',FInputList);
end;

procedure TOpPrmSDCorrelation.SaveToStream(prmStream: TStream);
begin
 inherited SaveToStream(prmStream);
 prmStream.WriteBuffer(FInputList,sizeOf(FInputList));
end;

procedure TOpPrmSDCorrelation.SetDefaultParameters;
begin
 inherited SetDefaultParameters();
 FInputList:= 0;
end;

initialization
 RegisterClass(TMLGenCompSDCorrelation);
end.
