(***********************************************************************)
(* UCompSDManovaDefinition.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(***********************************************************************)

{
@abstract(composant de base pour les statistiques conditionnelles multivaries)
@author(Ricco)
@created(08/08/2005)


}

unit UCompSDManovaDefinition;

interface

USES
    Forms,
    UCompDefinition,
    UCompManageDataset,
    UCalcStatDes,
    UCalcStatDesManova,
    UCompSDDefinition,
    UOperatorDefinition;

TYPE

    //***********************************************************************************
    //********* Dfinition des classes de base "oprateurs descriptifs multivaris ******
    //***********************************************************************************

    //composant
    TMLCompSDDefManova = class(TMLCompLocalData)
                         end;

    //oprateur
    TOpSDDefManova = class(TOpSD)
                     protected
                     //rcuprer la classe de calcul individuelle -- surcharge obligatoire
                     function getClassStat(): TClassCalcSDCondMultivariate; virtual; abstract;
                     //rcuprer la classe de liste de rsultats -- surcharge obligatoire
                     function getClassLstStat(): TClassLstCalcSDCondManova; virtual; abstract;
                     //dfinir la bonne liste
                     procedure   InitializeListStat(); override;
                     //construire chaque stat.
                     procedure   RebuildStatDes(); override;
                     //vrifier les variables slectionnes
                     function    CheckAttributes(): boolean; override;
                     //calcul sur les observations
                     function    CoreExecute(): boolean; override;
                     end;

    //paramtrage
    TOpPrmSDDefManova = class(TOperatorParameter)
                        protected
                        function    CreateDlgParameters(): TForm; override;
                        procedure   SetDefaultParameters(); override;
                        end;

    //**************************************************************************
    //*********** Composant MANOVA *********************************************
    //**************************************************************************

    //gnrateur de composant
    TMLGenCompManova = class(TMLGenComp)
                       protected
                       procedure   GenCompInitializations(); override;
                       public
                       function    GetClassMLComponent: TClassMLComponent; override;
                       end;

    //composant
    TMLCompSDManova = class(TMLCompSDDefManova)
                      protected
                      function    getClassOperator: TClassOperator; override;
                      end;

    //oprateur
    TOpSDManova = class(TOpSDDefManova)
                  protected
                  //rcuprer la classe de calcul individuelle -- surcharge obligatoire
                  function getClassStat(): TClassCalcSDCondMultivariate; override;
                  //rcuprer la classe de liste de rsultats -- surcharge obligatoire
                  function getClassLstStat(): TClassLstCalcSDCondManova; override;
                  //paramtrage
                  function    getClassParameter: TClassOperatorParameter; override;
                  end;

    //paramtrage
    TOpPrmSDManova = class(TOpPrmSDDefManova)
                     end;   


implementation

uses
    Classes,
    UDatasetImplementation, UDatasetDefinition;

{ TOpPrmSDDefManova }

function TOpPrmSDDefManova.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

procedure TOpPrmSDDefManova.SetDefaultParameters;
begin
 //none
end;

{ TOpSDDefManova }

function TOpSDDefManova.CheckAttributes: boolean;
var ok: boolean;
begin
 //target > 1 et tous continus
 ok:= (self.WorkData.LstAtts[asTarget].Count > 1) and (self.WorkData.LstAtts[asTarget].isAllCategory(caContinue));
 //input > 0 et tous discrets
 ok:= ok and ((self.WorkData.LstAtts[asInput].Count > 0) and (self.WorkData.LstAtts[asInput].isAllCategory(caDiscrete)));
 //
 result:= ok;
end;

function TOpSDDefManova.CoreExecute: boolean;
begin
 result:= true;
 try
 self.RebuildStatDes();
 self.LstStat.RefreshStat(WorkData.Examples);
 except
 result:= false;
 end;
end;

procedure TOpSDDefManova.InitializeListStat;
begin
 FLstStat:= getClassLstStat().Create(nil,nil);
end;

procedure TOpSDDefManova.RebuildStatDes;
var j: integer;
    stat: TCalcSDCondMultivariate;
    att: TAttribute;
begin
 FLstStat.FreeAll();
 for j:= 0 to pred(self.WorkData.LstAtts[asInput].Count) do
  begin
   att:= self.WorkData.LstAtts[asInput].Attribute[j];
   stat:= getClassStat.create(att,self.WorkData.LstAtts[asTarget],nil);
   FLstStat.AddStat(stat);
  end;
end;

{ TMLGenCompManova }

procedure TMLGenCompManova.GenCompInitializations;
begin
 FMLComp:= mlcDescriptiveStat;
end;

function TMLGenCompManova.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDManova;
end;

{ TMLCompSDManova }

function TMLCompSDManova.getClassOperator: TClassOperator;
begin
 result:= TOpSDManova; 
end;

{ TOpSDManova }

function TOpSDManova.getClassLstStat: TClassLstCalcSDCondManova;
begin
 result:= TLstCalcSDCondManova;
end;

function TOpSDManova.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSDManova; 
end;

function TOpSDManova.getClassStat: TClassCalcSDCondMultivariate;
begin
 result:= TCalcSDCondManova;
end;

initialization
 RegisterClass(TMLGenCompManova);
end.
