(****************************************************************************)
(* UCompSDUnivContNormalityTest.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(****************************************************************************)

{
@abstract(Composant statistique -- Test de normalit)
@author(Ricco)
@created(29/07/2005)
}

unit UCompSDUnivContNormalityTest;

interface

uses
        Forms, Classes,
        UCompDefinition,
        UCompSDDefinition,
        UOperatorDefinition,
        UCompManageDataset;

type
        {Gnrateur de univariate stat cont desc}
        TMLGenCompSDUnivNormalityTest = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

        {le composant}
        TMLCompSDUnivNormalityTest = class(TMLCompSD)
                                protected
                                function    getClassOperator: TClassOperator; override;
                                function    GetLogResultDescription(): string; override;
                                end;

        {l'oprateur associ}
        TOpSDUnivNormalityTest  = class(TOpSD)
                                protected
                                procedure   InitializeListStat(); override;
                                function    getClassParameter: TClassOperatorParameter; override;
                                procedure   RebuildStatDes(); override;
                                function    CheckAttributes(): boolean; override;
                                function    CheckExamples(): boolean; override;
                                public
                                end;

        {le paramtrage}
        TOpPrmSDUnivNormalityTest = class(TOpPrmSD)
                           protected
                           function    CreateDlgParameters(): TForm; override;
                           public
                           function    getHTMLParameters(): string; override;
                           end;


implementation

USES
        Sysutils,
        UDatasetDefinition,
        UDatasetImplementation, UCalcStatDesNormalityTest;

CONST
        //ces limitations sont surtout importantes pour le test de Shapiro-Wilks

        //taille minimale de l'chantillon de travail ( cause de la table de Lilliefors)
        NORMALITY_TEST_MIN_SIZE = 4;

{ TMLGenCompSDUnivNormalityTest }

procedure TMLGenCompSDUnivNormalityTest.GenCompInitializations;
begin
 FMLComp:= mlcDescriptiveStat;
end;

function TMLGenCompSDUnivNormalityTest.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDUnivNormalityTest; 
end;

{ TMLCompSDUnivNormalityTest }

function TMLCompSDUnivNormalityTest.getClassOperator: TClassOperator;
begin
 result:= TOpSDUnivNormalityTest; 
end;

function TMLCompSDUnivNormalityTest.GetLogResultDescription: string;
begin
 result:= Format('stats on %d examples for %d attributes',
          [(self.Operator as TOpLocalData).WorkData.Examples.Size,(self.Operator as TOpLocalData).WorkData.LstAtts[asInput].Count]);
end;

{ TOpSDUnivNormalityTest }

function TOpSDUnivNormalityTest.CheckAttributes: boolean;
begin
 result:= (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caContinue));
end;

function TOpSDUnivNormalityTest.CheckExamples: boolean;
begin
 //au moins 4 individus pour pouvoir lancer les tests de normalit (primordial pour KS-Lilliefors)
 result:= (self.WorkData.Examples.Size >= NORMALITY_TEST_MIN_SIZE);
end;

function TOpSDUnivNormalityTest.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSDUnivNormalityTest; 
end;

procedure TOpSDUnivNormalityTest.InitializeListStat;
begin
 FLstStat:= TLstCalcSDContNormalityTest.Create(nil,nil);
end;

procedure TOpSDUnivNormalityTest.RebuildStatDes;
var i: integer;
    att: TAttribute;
    stat: TCalcSDContNormalityTest;
begin
 //si modification des paramtres, rcupration des nouvelles variables
 for i:= 0 to pred(workdata.LstAtts[asInput].Count) do
  begin
   att:= workdata.LstAtts[asInput].Attribute[i];
   if att.isCategory(caContinue)
    then
     begin
      stat:= TCalcSDContNormalityTest.Create(att,NIL);//nil, pas de calculs
      self.LstStat.AddStat(stat);
     end;
  end;
end;

{ TOpPrmSDUnivNormalityTest }

function TOpPrmSDUnivNormalityTest.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

function TOpPrmSDUnivNormalityTest.getHTMLParameters: string;
var sHtml: string;
begin
 sHTML:= format('<P><B>Attributes : </B>%d<BR>',[(Operator as TOpSDUnivNormalityTest).LstStat.Count]);
 sHTML:= sHTML+format('<B>Examples : </B>%d<BR>',[(Operator as TOpSDUnivNormalityTest).Workdata.Examples.Size]);
 result:= sHTML;
end;

initialization
 RegisterClass(TMLGenCompSDUnivNormalityTest);
end.
