(*************************************************************************)
(* UCompSDPairedTestSignTest.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(*************************************************************************)

{
@abstract(Test des signes)
@author(Ricco)
@created(17/07/2005)

Siegel -- pp. 80

}

unit UCompSDPairedTestSignTest;

interface

USES
   UCompDefinition, UOperatorDefinition,
   UCompSDPairedTestDefinition,UCalcStatDesPairedTest;

TYPE
   //gnrateur
   TMLGenCompSDSignTest = class(TMLGenComp)
                          protected
                          procedure   GenCompInitializations(); override;
                          public
                          function    GetClassMLComponent: TClassMLComponent; override;
                          end;

   //composant
   TMLCompSDSignTest = class(TMLCompSDPairedTestDefintion)
                       protected
                       function    getClassOperator: TClassOperator; override;
                       end;

   //oprateur
   TOpSDSignTest = class(TOpSDPairedTestDefinition)
                   protected
                   function    getClassStat(): TClassCalcSDPairedTest; override;
                   function    getClassLstStat(): TClassLstCalcSDPairedTest; override;
                   function    getClassParameter: TClassOperatorParameter; override;
                   end;

   //paramtrage
   TOpSDPrmSignTest = class(TOpPrmSDPairedTestDefinition)
                      end;


implementation

USES
   Classes;

{ TMLGenCompSDSignTest }

procedure TMLGenCompSDSignTest.GenCompInitializations;
begin
 FMLComp:= mlcNonParametricStatistics;
end;

function TMLGenCompSDSignTest.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDSignTest;
end;

{ TMLCompSDSignTest }

function TMLCompSDSignTest.getClassOperator: TClassOperator;
begin
 result:= TOpSDSignTest;
end;

{ TOpSDSignTest }

function TOpSDSignTest.getClassLstStat: TClassLstCalcSDPairedTest;
begin
 result:= TLstCalcSDSignTest;
end;

function TOpSDSignTest.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpSDPrmSignTest; 
end;

function TOpSDSignTest.getClassStat: TClassCalcSDPairedTest;
begin
 result:= TCalcSDSignTest;
end;

initialization
 RegisterClass(TMLGenCompSDSignTest);
end.
