(*************************************************************************)
(* UCompSDTTestEqualVariance.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(*************************************************************************)

{
@abstract(Comparaison de populations -- Test de Student d'galit des moyennes, variances gales)
@author(Ricco)
@created(25/07/2005)

http://www.itl.nist.gov/div898/handbook/eda/section3/eda353.htm

}

unit UCompSDTTestEqualVariance;

interface

USES
   UCompDefinition, UOperatorDefinition,
   UCompSDCondDescDefinition,UCalcStatDesConditionnalDesc;

TYPE
   //gnrateur
   TMLGenCompSDTTestEqVariance = class(TMLGenComp)
                          protected
                          procedure   GenCompInitializations(); override;
                          public
                          function    GetClassMLComponent: TClassMLComponent; override;
                          end;

   //composant
   TMLCompSDTTestEqVariance = class(TMLCompSDCondDescDefinition)
                       protected
                       function    getClassOperator: TClassOperator; override;
                       end;

   //oprateur
   TOpSDTTestEqVariance = class(TOpSDCondDescBinary)
                   protected
                   function    getClassStat(): TClassCalcSDCondDesc; override;
                   function    getClassLstStat(): TClassLstCalcStatDesCond; override;
                   function    getClassParameter: TClassOperatorParameter; override;
                   end;

   //paramtrage
   TOpSDPrmTTestEqVariance = class(TOpPrmSDCondDescDefinition)
                      end;


implementation

USES
   Classes;

{ TMLGenCompSDTTestEqVariance }

procedure TMLGenCompSDTTestEqVariance.GenCompInitializations;
begin
 FMLComp:= mlcDescriptiveStat;
end;

function TMLGenCompSDTTestEqVariance.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDTTestEqVariance;
end;

{ TMLCompSDTTestEqVariance }

function TMLCompSDTTestEqVariance.getClassOperator: TClassOperator;
begin
 result:= TOpSDTTestEqVariance;
end;

{ TOpSDTTestEqVariance }

function TOpSDTTestEqVariance.getClassLstStat: TClassLstCalcStatDesCond;
begin
 result:= TLstStatDescCondTTest;
end;

function TOpSDTTestEqVariance.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpSDPrmTTestEqVariance;
end;

function TOpSDTTestEqVariance.getClassStat: TClassCalcSDCondDesc;
begin
 result:= TCalcSDTTestEqualVariance;
end;

initialization
 RegisterClass(TMLGenCompSDTTestEqVariance);
end.
