(*************************************************************************)
(* UCompSDCondDescDefinition.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(*************************************************************************)

{
@abstract(composant de base pour les comparaisons de populations)
@author(Ricco)
@created(17/07/2005)

Permet de remonter  un niveau plus gnrique le contrle des attributs et l'appel
des classes de calcul

}

unit UCompSDCondDescDefinition;

interface

USES
   Forms,
   UCompSDDefinition,
   UCalcStatDesConditionnalDesc;

TYPE

   //classe de composant gnrique
   TMLCompSDCondDescDefinition = class(TMLCompSD)
                                protected
                                function    GetLogResultDescription(): string; override;
                                end;

   //classe de calcul gnrique
   TOpSDCondDescDefinition = class(TOpSD)
                             protected
                             //rcuprer la classe de calcul individuelle -- surcharge obligatoire
                             function getClassStat(): TClassCalcSDCondDesc; virtual; abstract;
                             //rcuprer la classe de liste de rsultats -- surcharge obligatoire
                             function getClassLstStat(): TClassLstCalcStatDesCond; virtual; abstract;
                             //construire la liste initiale vide -- ne pas surcharger par la suite
                             procedure   InitializeListStat(); override;
                             //construire les stats et ajouter dans la liste -- ne pas surcharger
                             procedure   RebuildStatDes(); override;
                             //tester la conformit des attributs avec les calculs -- surcharger uniquement dans le cas binaire (comparaison de 2 populations)
                             function    CheckAttributes(): boolean; override;
                             end;

   //classe de paramtrage gnrique
   TOpPrmSDCondDescDefinition = class(TOpPrmSD)
                               protected
                               function    CreateDlgParameters(): TForm; override;
                               public
                               function    getHTMLParameters(): string; override;
                               end;

   //classe gnrique pour les comparaisons binaires (de 2 populations -- Mann-Whitney, T-test, etc.)
   TOpSDCondDescBinary = class(TOpSDCondDescDefinition)
                         protected
                         //tester la conformit des attributs avec les calculs -- surcharger uniquement dans le cas binaire (comparaison de 2 populations)
                         function    CheckAttributes(): boolean; override;
                         end;

implementation

USES
   Sysutils,
   UConstConfiguration,
   UDlgOpPrmSDOneWayAnova,
   UDatasetDefinition,
   UDatasetImplementation;

{ TOpSDCondDescDefinition }

function TOpSDCondDescDefinition.CheckAttributes: boolean;
var ok: boolean;
begin
 ok:= (self.WorkData.LstAtts[asTarget].Count>0) and (self.WorkData.LstAtts[asTarget].isAllCategory(caContinue));
 ok:= ok and (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caDiscrete));
 result:= ok;
end;

procedure TOpSDCondDescDefinition.InitializeListStat;
begin
 FLstStat:= getClassLstStat.Create(nil,nil);
end;

procedure TOpSDCondDescDefinition.RebuildStatDes;
var stat: TCalcSDCondDesc;
    attD,attC: TAttribute;
    j,i: integer;
begin
 //vider la liste courante
 self.LstStat.FreeAll();
 //pour chaque variable de description
 for j:= 0 to pred(workdata.LstAtts[asInput].Count) do
  begin
   attD:= workdata.LstAtts[asInput].Attribute[j];
   //le type est ok ?
   if attD.isCategory(caDiscrete)
    then
     begin
      //les variables  dcrire
      for i:= 0 to pred(WorkData.LstAtts[asTarget].Count) do
       begin
        attC:= WorkData.LstAtts[asTarget].Attribute[i];
        //petit test quand mme
        if attC.isCategory(caContinue)
         then
          begin
           stat:= getClassStat().Create(attC,attD,nil);
           self.LstStat.AddStat(stat);
          end;
       end;
     end;
  end;
end;

{ TOpSDCondDescBinary }

function TOpSDCondDescBinary.CheckAttributes: boolean;
var j: integer;
    ok: boolean;
begin
 ok:= inherited CheckAttributes();
 if ok
  then
   begin
    //tester s'ils sont tous binaires
    for j:= 0 to pred(workdata.LstAtts[asInput].Count) do
     ok:= ok and (workdata.LstAtts[asInput].Attribute[j].nbValues = 2);
   end;
 //and then...
 result:= ok;
end;

{ TMLCompSDCondDescDefintion }

function TMLCompSDCondDescDefinition.GetLogResultDescription: string;
begin
 result:= Format('Description of %d continuous attributes from %d discrete one, %d examples',[(Operator as TOpSDCondDescDefinition).WorkData.LstAtts[asTarget].Count,
                (Operator as TOpSDCondDescDefinition).WorkData.LstAtts[asInput].Count,(Operator as TOpSDCondDescDefinition).WorkData.Examples.Size]);
end;

{ TOpPrmSDCondDescDefintion }

function TOpPrmSDCondDescDefinition.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmOneWayAnova.CreateFromOpPrm(self);
end;

function TOpPrmSDCondDescDefinition.getHTMLParameters: string;
var s,sPrm: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>Parameters</TH></TR>';
 if self.SortResult
  then sPrm:= 'yes'
  else sPrm:= 'no';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Sort results</TD><TD>%s</TD></TR>',[sPrm]);
 if self.SortResult
  then
   begin
    case self.SortCriteria of
     0: sPrm:= 'Target attribute name';
     1: sPrm:= 'Input attribute name';
     2: sPrm:= 'Statistic';
     3: sPrm:= 'p-value(Statistic)';
    end;
    s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Sort criterion</TD><TD>%s</TD></TR>',[sPrm]);
   end;
 s:= s+'</table>';
 result:= s;
end;

end.
