(************************************************************)
(* UDlgOpPrmPCA.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************)

unit UDlgOpPrmPCA;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, lmdstdcA;

type
  TDlgOpPrmPCA = class(TDlgBaseOperatorParameter)
    rgAxis: TRadioGroup;
    spinAxis: TLMDSpinEdit;
    procedure rgAxisClick(Sender: TObject);
  private
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;  
  end;

var
  DlgOpPrmPCA: TDlgOpPrmPCA;

implementation

uses UCompFactAnalysisPCA;

{$R *.dfm}

procedure TDlgOpPrmPCA.ApplyModifications;
var prm: TOpPrmFactPCA;
begin
 prm:= OpPrm as TOpPrmFactPCA;
 if (rgAxis.ItemIndex=0)
  then prm.NbAxisCreated:= -1
  else prm.NbAxisCreated:= spinAxis.Value;
end;

procedure TDlgOpPrmPCA.rgAxisClick(Sender: TObject);
begin
 if (rgAxis.ItemIndex=0)
  then spinAxis.Enabled:= FALSE
  else spinAxis.Enabled:= TRUE;
end;

procedure TDlgOpPrmPCA.SetParameters;
var prm: TOpPrmFactPCA;
begin
 prm:= OpPrm as TOpPrmFactPCA;
 if (prm.NbAxisCreated<0)
  then rgAxis.ItemIndex:= 0
  else
   begin
    rgAxis.ItemIndex:= 1;
    spinAxis.Value:= prm.NbAxisCreated;
   end;
end;

end.
