(*****************************************************************************)
(* UCompFactDiscriminantAnalysis.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(*****************************************************************************)

{
@abstract(Analyse Factorielle Discriminante)
@author(Ricco)
@created(10/08/2005)

Canonical Discriminant Analysis, connue sous le nom d'Analyse Factorielle Discriminante
ou Analyse Discriminante Descriptive : l'objectif est de construire des axes factoriels de
manire supervise (une ACP sur les centre de gravits des groupes pondre par l'inverse de
la matrice de var-covariance).

Son principale intrt est qu'il produit des axes factoriels rsums, indpendants deux  deux, et
qu'un test statistique permet de savoir lesquels apportent vraiment de l'information.

Le nombre de classes  produire est gal au (nombre de groupes - 1) de la variable TARGET.

}

unit UCompFactDiscriminantAnalysis;

interface

USES
  Classes, Forms,
  IniFiles,
  UCompDefinition,
  UCompFADefinition,
  UOperatorDefinition,
  UCompManageDataset,
  UCalcFactDiscriminantAnalysis;

TYPE
    {gnrateur de composant}
    TMLGenCompFactDiscAnalysis = class(TMLGenComp)
                                 protected
                                 procedure   GenCompInitializations(); override;
                                 public
                                 function    GetClassMLComponent: TClassMLComponent; override;
                                 end;

    {composant DiscAnalysis}
    TMLCompFactDiscAnalysis = class(TMLCompFactAnalysis)
                              protected
                              function    getClassOperator: TClassOperator; override;
                              end;

    {oprateur DiscAnalysis}
    TOpFactDiscAnalysis = class(TOpLocalData)
                          private
                          //objet de calcul
                          FCalc: TCalcFactDiscriminant;
                          protected
                          function    CheckAttributes(): boolean; override;
                          function    CoreExecute(): boolean; override;
                          function    getClassParameter: TClassOperatorParameter; override;
                          procedure   setProjection();
                          public
                          destructor  destroy(); override;
                          function    getHTMLResultsSummary(): string; override;
                          end;

    {paramtrage de l'oprateur DiscAnalysis}
    TOpPrmFactDiscAnalysis = class(TOpPrmFactAnalysis)
                             protected
                             function    CreateDlgParameters(): TForm; override;
                             procedure   SetDefaultParameters(); override;
                             end;   

implementation

uses
  Sysutils,
  UDatasetExamples, UDatasetImplementation, UDatasetDefinition,
  ULogFile, UConstConfiguration, UCalcMatrixAdditionalFunctions;

{ TOpPrmFactDiscAnalysis }

function TOpPrmFactDiscAnalysis.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

procedure TOpPrmFactDiscAnalysis.SetDefaultParameters;
begin
 //none
end;

{ TMLGenCompFactDiscAnalysis }

procedure TMLGenCompFactDiscAnalysis.GenCompInitializations;
begin
 FMLComp:= mlcFactorialAnalysis;
end;

function TMLGenCompFactDiscAnalysis.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompFactDiscAnalysis; 
end;

{ TMLCompFactDiscAnalysis }

function TMLCompFactDiscAnalysis.getClassOperator: TClassOperator;
begin
 result:= TOpFactDiscAnalysis; 
end;

{ TOpFactDiscAnalysis }

function TOpFactDiscAnalysis.CheckAttributes: boolean;
var ok: boolean;
begin
 //tous continus ou quasi-continus pour INPUT
 ok:= (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caQuasiContinue));
 //un target discret
 ok:= ok and ((self.WorkData.LstAtts[asTarget].Count = 1) and (self.WorkData.LstAtts[asTarget].isAllCategory(caDiscrete)));
 //and then...
 result:= ok;
end;

function TOpFactDiscAnalysis.CoreExecute: boolean;
begin
 if assigned(FCalc) then FCalc.Free();
 result:= FALSE;
 TRY
 FCalc:= TCalcFactDiscriminant.create(self.WorkData.LstAtts[asTarget].Attribute[0],self.WorkData.LstAtts[asInput]);
 if FCalc.compute(self.WorkData.Examples)
  then
   begin
    self.setProjection();
    result:= TRUE;
   end;
 EXCEPT
 if assigned(FCalc) then FreeAndNil(FCalc);
 END;
end;

destructor TOpFactDiscAnalysis.destroy;
begin
 if assigned(FCalc) then FCalc.Free();
 inherited;
end;

function TOpFactDiscAnalysis.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmFactDiscAnalysis; 
end;

function TOpFactDiscAnalysis.getHTMLResultsSummary: string;
begin
 if assigned(FCalc)
  then result:= FCalc.getHTMLResults()
  else result:= 'error during computation';
end;

procedure TOpFactDiscAnalysis.setProjection;
var k: integer;
    newAtt: TAttribute;
begin
 //vider la liste des variables dj produites
 GenAtts.Clear();
 //reconstruire la liste des variables  produire
 for k:= 1 to FCalc.NbRacines do
  begin
   newAtt:= TAttContinue.Create(Format('CDA_%d_Axis_%d',[(MLOwner as TMLCompFactDiscAnalysis).Number,k]),WorkData.LstAtts[asAll].Size);
   GenAtts.Add(newAtt);
  end;
 //puis demander leur remplissage par projection dans le nouvel espace
 FCalc.setProjection(GenAtts);
end;


initialization
 RegisterClass(TMLGenCompFactDiscAnalysis);
end.
