(*****************************************************************)
(* UCompFADefinition.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*****************************************************************)

{
@abstract(Definition de la classe d'objet "Analyse factorielle")
@author(Ricco)
@created(12/01/2004)
Utilisation intensive des mthodes matricielles. Bcp d'optimisations  prvoir.
}
unit UCompFADefinition;

interface

USES
        UCompManageDataset,
        UOperatorDefinition;

TYPE
        {Classe gnrique de composant analyse factorielle}
        TMLCompFactAnalysis = class(TMLCompLocalData)
                              protected
                              function    GetLogResultDescription(): string; override; 
                              end;

        {Classe gnrique d'oprateur Fact Analysis,
        la gestion des donnes gnres localement va tre trs importante,
        le nombre de ces nouvelles variables sera constamment modifie selon les paramtres de l'analyse}
        TOpFactAnalysis = class(TOpLocalData)
                          protected
                          procedure   ReInitialize(); override;
                          procedure   DelPrivateMatrix(); virtual; abstract;
                          public
                          destructor  Destroy(); override;     
                          end;

        {paramtrage d'une analyse factorielle}
        TOpPrmFactAnalysis = class(TOperatorParameter)
                             end;   


implementation

uses
   UDatasetImplementation,
   Sysutils;

{ TOpFactAnalysis }

destructor TOpFactAnalysis.Destroy;
begin
 self.DelPrivateMatrix();
 inherited Destroy();
end;

procedure TOpFactAnalysis.ReInitialize;
begin
 inherited ReInitialize();
 self.DelPrivateMatrix();
end;

{ TMLCompFactAnalysis }

function TMLCompFactAnalysis.GetLogResultDescription: string;
var data: TMLDataset;
begin
 data:= (Operator as TOpLocalData).WorkData;
 result:= Format('%d attributes, and %d examples',[data.LstAtts[asInput].Count,data.Examples.Size]);
end;

end.
