(***********************************************************************************)
(* UCompFCBinarizeDiscreteToContinuous.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***********************************************************************************)

{
@abstract(Codage disjonctif complet)
@author(Ricco)
@created(25/04/2004)
}
unit UCompFCBinarizeDiscreteToContinuous;

interface

USES
        Forms, Classes, IniFiles,
        UCompDefinition,
        UCompFCDefinition,
        UOperatorDefinition,
        UCalcStatDes, UDatasetDefinition, UDatasetImplementation;

TYPE
        {gnrateur de composant}
        TGenFCBinarizationContinuous = class(TMLGenComp)
                                       protected
                                       procedure   GenCompInitializations(); override;
                                       public
                                       function    GetClassMLComponent: TClassMLComponent; override;
                                       end;

        {composant}
        TMLCompFCBinContinuous  = class(TMLCompFC)
                                  protected
                                  function    getClassOperator: TClassOperator; override;
                                  function    GetLogResultDescription(): string; override;
                                  end;

        {oprateur}
        TOpFCBinContinuous = class(TOperatorFC)
                             protected
                             function  CheckAttributes(): boolean; override;
                             function  getClassParameter: TClassOperatorParameter; override;
                             function    CoreExecute(): boolean; override;
                             public
                             function    getHTMLResultsSummary(): string; override;
                             end;

        {paramtrage}
        TOpPrmFCBinContinuous = class(TOperatorPrmFC)
                                protected
                                function    CreateDlgParameters(): TForm; override;
                                procedure   SetDefaultParameters(); override;
                                end;

implementation

USES
        Sysutils, UConstConfiguration;

{ TGenFCBinarizationContinuous }

procedure TGenFCBinarizationContinuous.GenCompInitializations;
begin
 FMLComp:= mlcFeatureConstruction;
end;

function TGenFCBinarizationContinuous.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompFCBinContinuous;
end;

{ TMLCompFCBinContinuous }

function TMLCompFCBinContinuous.getClassOperator: TClassOperator;
begin
 result:= TOpFCBinContinuous;
end;

function TMLCompFCBinContinuous.GetLogResultDescription: string;
begin
 result:= format('%d continuous attributes generated',[LocalDataset.Count]);
end;

{ TOpFCBinContinuous }

function TOpFCBinContinuous.CheckAttributes: boolean;
begin
 result:= (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caDiscrete));
end;

function TOpFCBinContinuous.CoreExecute: boolean;
var j,i,k,v,nbValues: integer;
    attSource: TAttDiscrete;
    attDest: array of TAttContinue;
begin
 result:= TRUE;
 TRY
  //vider la liste courante
  GenAtts.Clear();
  //pour chaque attribut  coder
  for j:= 0 to pred(self.WorkData.LstAtts[asInput].Count) do
   begin
    attSource:= self.WorkData.LstAtts[asInput].Attribute[j] as TAttDiscrete;
    //nombre de valeurs
    nbValues:= attSource.nbValues;
    //crer les variables 0/1, sauf la dernire
    SetLength(attDest,nbValues);
    for k:= 1 to pred(nbValues) do
     begin
      attDest[k]:= TAttContinue.Create(attSource.Name+'_'+attSource.LstValues.getDescription(k)+'_'+IntToStr((self.MLOwner as TMLCompFCBinContinuous).Number),attSource.Size);
      GenAtts.Add(attDest[k]);
     end;
    //coder
    for i:= 1 to attSource.Size do
     begin
      //tous  zro
      for k:= 1 to pred(nbValues) do
       attDest[k].cValue[i]:= 0.0;
      //sauf celui qui correspond
      v:= attSource.dValue[i];
      if (v<nbValues)
       then attDest[v].cValue[i]:= 1.0;
     end;
   end;
  //librer tout de suite -- mme s'il y a un compteur de rfrences (semble-t-il ?)
  SetLength(attDest,0);
 EXCEPT
 result:= FALSE;
 END;
end;

function TOpFCBinContinuous.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmFCBinContinuous;
end;

function TOpFCBinContinuous.getHTMLResultsSummary: string;
var s,tmp: string;
    j,k,i: integer;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan="2">Attribute binarization</TH></TR>';
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH>Source att</TH><TH>New attributes</TH></TR>';
 k:= 0;
 for j:= 0 to pred(self.WorkData.LstAtts[asInput].Count) do
  begin
   //lister
   tmp:= '(';
   for i:= k to k+self.WorkData.LstAtts[asInput].Attribute[j].nbValues-2 do
    tmp:= tmp+self.GenAtts.Attribute[i].Name+',';
   tmp[length(tmp)]:= ')';
   //dcaler
   inc(k,self.WorkData.LstAtts[asInput].Attribute[j].nbValues-1);
   //afficher
   s:= s+ HTML_TABLE_COLOR_DATA_GRAY
       + format('<TD>%s</TD>',[self.WorkData.LstAtts[asInput].Attribute[j].Name])
       + format('<TD>%s</TD>',[tmp])
       + '</TR>';
  end;
 s:= s+'</table>';
 result:= s;
end;

{ TOpPrmFCBinContinuous }

function TOpPrmFCBinContinuous.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

procedure TOpPrmFCBinContinuous.SetDefaultParameters;
begin
 //none
end;

initialization
 RegisterClass(TGenFCBinarizationContinuous);
end.
