(**************************************************************************)
(* UDlgOpPrmFormulaContinuous.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(**************************************************************************)

unit UDlgOpPrmFormulaContinuous;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, UCompFCFormula,UDatasetDefinition;

type
  TDlgOpPrmFormulaContinuous = class(TDlgBaseOperatorParameter)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edFormula: TEdit;
    Panel2: TPanel;
    lstboxAtt: TListBox;
    procedure lstboxAttDblClick(Sender: TObject);
  private
    FOpPrmFormula: TOpFCFormulaPrm;
    FLstAtts: TLstAttributes;
  public
    {rcuprer la formule, aprs l'avoir valide}
    procedure   ApplyModifications(); override;
    {afficher les atts et la formule}
    procedure   SetParameters(); override;
  end;

var
  DlgOpPrmFormulaContinuous: TDlgOpPrmFormulaContinuous;

implementation

uses UDatasetImplementation;

{$R *.dfm}

{ TDlgOpPrmFormulaContinuous }

procedure TDlgOpPrmFormulaContinuous.ApplyModifications;
begin
 FOpPrmFormula.Formula:= edFormula.Text;
end;

procedure TDlgOpPrmFormulaContinuous.SetParameters;
var    att: TAttribute;
       i: integer;     
begin
 FOpPrmFormula:= OpPrm as TOpFCFormulaPrm;
 //liste des attributs
 FLstAtts:= (FOpPrmFormula.Operator as TOpFCFormula).WorkData.LstAtts[asAll];
 for i:= 0 to pred(FLstAtts.Count) do
  begin
   att:= FLstAtts.Attribute[i];
   if att.isCategory(caContinue)
    then lstboxAtt.Items.AddObject(att.Name,att);
  end;
 //la formule
 edFormula.Text:= FOpPrmFormula.Formula; 
end;

procedure TDlgOpPrmFormulaContinuous.lstboxAttDblClick(Sender: TObject);
Var NameVar, CurrentFormula: String;
    PosSel: Integer;
begin
 //ajouter le nom de variable dans la formule
 If (lstboxAtt.ItemIndex>=0)
  Then
   Begin
    NameVar:= lstBoxAtt.Items[lstboxAtt.ItemIndex];
    CurrentFormula:= EdFormula.Text;
    PosSel:=EdFormula.SelStart;
    Insert(NameVar,CurrentFormula,Succ(PosSel));
    EdFormula.Text:= CurrentFormula;
    EdFormula.SetFocus;
    EdFormula.SelStart:= PosSel+Length(NameVar);
    EdFormula.SelLength:= 0;
   End;
end;

end.
