(************************************************************************)
(* UCompFCDiscBinaryBinning.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************************)

{
@abstract(Composant : discrtisation binaire sur un seuil)
@author(Ricco)
@created(27/04/2005)

2 types de seuils :
(a) la moyenne (pour l'instant) ou tout autre param. stat
(b) user defined

le "seuil" joue dans le sens :

code 1 : x < seuil
code 2 : x >= seuil

}

unit UCompFCDiscBinaryBinning;

interface

USES
        Forms, Classes, IniFiles,
        UCompDefinition,
        UOperatorDefinition,
        UCompFCDiscDefinition,
        UDatasetDefinition;

TYPE
        //paramtrage du type de discrtisation -- on peut l'enrichir plus tard (ex. avg+a*ecart-type...)
        TEnumTypeCutPoint = (bbCutUserDefined, bbCutAverage);

CONST
        STR_TYPE_CUT_POINT_BINARY_BINNING : array[TEnumTypeCutPoint] of string = ('User defined','Average');

TYPE
        {gnrateur de composant}
        TGenFCDiscBinning = class(TGenFCDiscBase)
                            public
                            function    GetClassMLComponent: TClassMLComponent; override;
                            end;

        {composant}
        TMLFCDiscBinning  = class(TMLFCDiscBase)
                            protected
                            function    getGenericAttName(): string; override;
                            function    getClassOperator: TClassOperator; override;
                            end;

        {oprateur}
        TOpFCDiscBinning  = class(TOpFCDiscBase)
                            protected
                            function    getClassParameter: TClassOperatorParameter; override;
                            procedure   BuildCutPoints(); override;
                            end;

        {paramtre de l'oprateur}
        TOpPrmFCDiscBinning = class(TOpPrmFCDiscBase)
                              private
                              //type de point de coupure
                              FTypeCutPoint: TEnumTypeCutPoint;
                              //valeur du point de coupure (si user defined)
                              FThreshold: TTypeContinue;
                              protected
                              procedure   SetDefaultParameters(); override;
                              function    CreateDlgParameters(): TForm; override;
                              public
                              function    getHTMLParameters(): string; override;
                              procedure   LoadFromStream(prmStream: TStream); override;
                              procedure   SaveToStream(prmStream: TStream); override;
                              procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                              procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                              property    TypeCutPoint: TEnumTypeCutPoint read FTypeCutPoint write FTypeCutPoint;
                              property    Threshold: TTypeContinue read FThreshold write FThreshold;
                              end; 


implementation

uses
   Sysutils,
   UConstConfiguration, UDlgOpPrmDiscBinBinning;

{ TGenFCDiscBinning }

function TGenFCDiscBinning.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLFCDiscBinning;
end;

{ TMLFCDiscBinning }

function TMLFCDiscBinning.getClassOperator: TClassOperator;
begin
 result:= TOpFCDiscBinning;
end;

function TMLFCDiscBinning.getGenericAttName: string;
begin
 result:= 'binning';
end;

{ TOpFCDiscBinning }

procedure TOpFCDiscBinning.BuildCutPoints;
var curThreshold: TTypeContinue;
    cAtt: TAttCutPoints;
    i,j: integer;
begin
 //pour chaque attribut
 for j:= 0 to pred(SetAttCutPoints.getNbAttCutPoints) do
  begin
   cAtt:= SetAttCutPoints.getAttCutPoints(j);
   case (self.PrmOp as TOpPrmFCDiscBinning).TypeCutPoint of
    bbCutUserDefined: curThreshold:= (self.PrmOp as TOpPrmFCDiscBinning).Threshold
    else
     begin
      curThreshold:= 0.0;
      for i:= 1 to workdata.Examples.Size do
       curThreshold:= curThreshold + cAtt.AttToDisc.cValue[workdata.Examples.Number[i]];
      curThreshold:= curThreshold/(1.0*workdata.Examples.Size); 
     end;
   end;
  //puis ajouter  la liste des cur-points, un seul appel donc
  cAtt.addCutPoint(curThreshold);
 end;
end;

function TOpFCDiscBinning.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmFCDiscBinning;
end;

{ TOpPrmFCDiscBinning }

function TOpPrmFCDiscBinning.CreateDlgParameters: TForm;
begin
 result:= TdlgOpPrmDiscBinBinning.CreateFromOpPrm(self);
end;

function TOpPrmFCDiscBinning.getHTMLParameters: string;
var s: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_BLUE+'<th colspan="2">Binary binning parameters</th></tr>';
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<td>Threshold</td><td align="right">%s</td></tr>',[STR_TYPE_CUT_POINT_BINARY_BINNING[FTypeCutPoint]]);
 if (FTypeCutPoint = bbCutUserDefined)
  then s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<td>Threshold value</td><td align="right">%.4f</td></tr>',[FThreshold]);
 s:= s+'</table>';
 //
 result:= s;
end;

procedure TOpPrmFCDiscBinning.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FTypeCutPoint:= TEnumTypeCutPoint(prmINI.ReadInteger(prmSection,'cut_point_type',ord(FTypeCutPoint)));
 FThreshold:= prmINI.ReadFloat(prmSection,'threshold',FThreshold);
end;

procedure TOpPrmFCDiscBinning.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FTypeCutPoint,sizeof(FTypeCutPoint));
 prmStream.ReadBuffer(FThreshold,sizeof(FThreshold));
end;

procedure TOpPrmFCDiscBinning.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'cut_point_type',ord(FTypeCutPoint));
 prmINI.WriteFloat(prmSection,'threshold',FThreshold);
end;

procedure TOpPrmFCDiscBinning.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FTypeCutPoint,sizeof(FTypeCutPoint));
 prmStream.WriteBuffer(FThreshold,sizeof(FThreshold));
end;

procedure TOpPrmFCDiscBinning.SetDefaultParameters;
begin
 //user-defined par dfaut
 FTypeCutPoint:= bbCutUserDefined;
 //et le seuil est 0.5
 FThreshold:= 0.5;
end;

initialization
 RegisterClass(TGenFCDiscBinning);
end.
