(****************************************************************)
(* UCompFCDiscMDLPC.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(****************************************************************)

{
@abstract(Composant : discrtisation avec la mthode MDLPC)
@author(Ricco)
@created(18/04/2004)

Discrtisation supervise, ncessite pas le tri des donnes, bcp d'astuces
sont ncessaires pour optimiser le temps de calcul...
}

unit UCompFCDiscMDLPC;

interface

USES
        Classes, Forms, Contnrs,
        UCompFCDiscDefinition,
        UCompDefinition,
        UOperatorDefinition,
        UDatasetExamples,
        UDatasetImplementation,
        UCalcDistribution;        

TYPE
        {gnrateur de composant}
        TGenFCDiscMDLPC = class(TGenFCDiscBase)
                          public
                          function    GetClassMLComponent: TClassMLComponent; override;
                          end;

        {composant mdlpc discretization}
        TMLFCDiscMDLPC = class(TMLFCDiscBase)
                         protected
                         function    getGenericAttName(): string; override;
                         function    getClassOperator: TClassOperator; override;
                         end;

        {une structure  dcouper - un noeud virtuel dans l'arbre de recherche des points de discrtisation}
        TNodeDisc = class(TObject)
                    public
                    iMin, iMax: integer;
                    distY: TTabFrequence;
                    constructor Create(attY: TAttDiscrete);
                    destructor  Destroy(); override; 
                    end;

        {oprateur}
        TOpFCDiscMDLPC  = class(TOpFCDiscBase)
                            private
                            {liste des noeuds}
                            FLstNodesDisc: TObjectList;
                            {calculer une entropie de Shannon -- attention, on multiplie par -1.0 pour avoir un rsultat positif !!!}
                            function    shannon(dist: TTabFrequence): double;
                            {chercher un point de coupure sur un noeud}
                            function    getCutPoint(attY: TAttDiscrete; cAtt: TAttCutPoints; node: TNodeDisc; sortList: TExamples; var newNode: TNodeDisc): boolean;
                            {discrtisation supervise d'un attribut}
                            procedure   mdlpc(attY: TAttDiscrete; cAtt: TAttCutPoints; sortList: TExamples);    
                            protected
                            function    CheckAttributes(): boolean; override;
                            function    getClassParameter: TClassOperatorParameter; override;
                            procedure   BuildCutPoints(); override;
                            public
                            constructor Create(AOwner: TObject); override;
                            destructor  Destroy; override;
                            end;

        {paramtre de l'oprateur}
        TOpPrmFCDiscMDLPC = class(TOpPrmFCDiscBase)
                            protected
                            procedure   SetDefaultParameters(); override;
                            function    CreateDlgParameters(): TForm; override;
                            end;

implementation

uses
        Math,
        UDatasetDefinition;


{ TGenFCDiscMDLPC }

function TGenFCDiscMDLPC.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLFCDiscMDLPC;
end;

{ TMLFCDiscMDLPC }

function TMLFCDiscMDLPC.getClassOperator: TClassOperator;
begin
 result:= TOpFCDiscMDLPC;
end;

function TMLFCDiscMDLPC.getGenericAttName: string;
begin
 result:= 'mdlpc';
end;

{ TOpFCDiscMDLPC }

procedure TOpFCDiscMDLPC.BuildCutPoints;
var j: integer;
    sortList: TExamples;
    cAtt: TAttCutPoints;
    attY: TAttDiscrete;
begin
 attY:= self.workdata.lstAtts[asTarget].Attribute[0] as TAttDiscrete;
 sortList:= TExamples.Create(self.WorkData.Examples.Size);
 //pour chaque attribut  discrtiser
 for j:= 0 to pred(SetAttCutPoints.getNbAttCutPoints) do
  begin
   //prparer la liste
   cAtt:= SetAttCutPoints.getAttCutPoints(j);
   sortList.Copy(self.WorkData.Examples);
   //lancer la discrtisation
   self.mdlpc(attY,cAtt,sortList);
   //vider la liste des noeuds
   FLstNodesDisc.Clear();
  end;
 sortList.Free;
end;

function TOpFCDiscMDLPC.CheckAttributes: boolean;
begin
 //discrtisation supervise !!!
 result:= inherited CheckAttributes() and
          ((self.WorkData.LstAtts[asTarget].Count=1) and (self.WorkData.LstAtts[asTarget].isAllCategory(caDiscrete)));
end;

constructor TOpFCDiscMDLPC.Create(AOwner: TObject);
begin
 inherited Create(AOwner);
 FLstNodesDisc:= TObjectList.Create(TRUE);//liste propritaire
end;

destructor TOpFCDiscMDLPC.Destroy;
begin
 FLstNodesDisc.Free;
 inherited Destroy();
end;

function TOpFCDiscMDLPC.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmFCDiscMDLPC;
end;

function TOpFCDiscMDLPC.getCutPoint(attY: TAttDiscrete; cAtt: TAttCutPoints; node: TNodeDisc; sortList: TExamples;
  var newNode: TNodeDisc): boolean;
var vK,vKL,vKR: double; //nombre de modalits relles - totales,  gauche et  droite
    vN,vNL,vNR: double; //effectif sur le noeud  splitter
    lNode,rNode: TNodeDisc; //les noeuds enfants candidats pour un split
    distL,distR: TTabFrequence; //tableaux intermdiaires de calcul
    i: integer; //indice de l'individu  passer
    j: integer; //pour scanner les modalits;
    mY: integer; //modalit de Y pour l'individu  traiter
    s,sL,sR: double; //entropie sur les sommets
    g,gMax: double; //gain d'entropie
    cSeuil,gSeuil: double; //la partie constante du seuil -  calculer qu'une seule fois
    findCutPoint: boolean;
begin
 //qqs initialisations
 newNode:= NIL;
 result:= FALSE;
 gMax:= -1.0e308;
 //effectif
 vN:= 1.0*succ(node.iMax-node.iMin);
 //s'il y a au moins deux points entre lesquels on peut tenter le coup
 if (vN>1)
  then
   begin
    //entropie globale
    s:= self.shannon(node.distY);
    //effectif gauche-droite
    vNL:= 0.0;
    vNR:= vN;
    //scanner les modalits rellement prsentes
    vK:= 0.0;
    for j:= 1 to node.distY.Size do
     if (node.distY.Value[j]>0) then vK:= vK+1.0;
    //pour les feuilles
    vKL:= 0;
    vKR:= vK;
    //calculer la partie constante du seuil
    cSeuil:= log2(vN-1.0)+log2(power(3.0,vK)-2.0)-vK*s;
    //prparer noeuds enfants -- les feuilles
    lNode:= TNodeDisc.Create(attY);
    lNode.iMin:= node.iMin;
    rNode:= TNodeDisc.Create(attY);
    rNode.iMax:= node.iMax;
    //les vecteurs de calcul
    distL:= TTabFrequence.CreateFromAtt(attY,NIL);
    distL.ReInitialization();
    distR:= TTabFrequence.CreateFromAtt(attY,NIL);
    distR.Copy(node.distY);
    //passer les individus de droite  gauche
    findCutPoint:= FALSE;
    for i:= node.iMin to pred(node.iMax) do
     begin
      mY:= attY.dValue[sortList.Number[i]];
      //modifier le nombre de modalits rellement prsentes, le cas chant
      if (distL.Value[mY]=0) then vKL:= vKL+1.0;
      if (distR.Value[mY]=1) then vKR:= vKR-1.0;
      //incrmenter et dcrmenter les cellules
      distL.IncrementCell(mY);
      distR.DecrementCell(mY);
      //idem effectifs feuilles
      vNL:= vNL+1.0;
      vNR:= vNR-1.0;
      //on n'est pas devant un ex-aequo ?
      if (cAtt.AttToDisc.cValue[sortList.Number[succ(i)]]>cAtt.AttToDisc.cValue[sortList.Number[i]])
       then
        begin
          //calculer le gain d'entropie
          sL:= self.shannon(distL);
          sR:= self.shannon(distR);
          g:= s-(vNL/vN*sL+vNR/vN*sR);
          //on passe le seuil et on amliore ?
          //viter de passer par une fonction, fusse-t-elle locale, doit bien amliorer la rapidit quand mme
          gSeuil:= (cSeuil+vKL*sL+vKR*sR)/vN;
          if (g>gSeuil) and (g>gMax)
           then
            begin
             findCutPoint:= TRUE;
             gMax:= g;
             //rcuprer les infos
             lNode.iMax:= i;
             lNode.distY.Copy(distL);
             rNode.iMin:= succ(i);
             rNode.distY.Copy(distR);
            end;
        end;
     end;
    //vider
    distL.Free();
    distR.Free();
    if not(findCutPoint)
     then rNode.Free()
     else
      //rcuprer les bonnes infos
      begin
       node.iMax:= lNode.iMax;
       node.distY.Copy(lNode.distY);
       //simple passage de pointeur, pas de cration intempestive -- pas de desctruction intempestive aussi
       newNode:= rNode;
       //et on est content...
       result:= TRUE;
      end;
    lNode.Free();
   end;
end;

procedure TOpFCDiscMDLPC.mdlpc(attY: TAttDiscrete; cAtt: TAttCutPoints;
  sortList: TExamples);
var i,i_curNode,i_maxNode: integer;
    curNode,newNode: TNodeDisc;
    cutPoint,leftPoint,rightPoint: TTypeContinue;
begin
 {***********************************************************}
 {* la grosse stratgie est d'viter une criture rcursive *}
 {* mais il s'agit bien d'un arbre de recherche *************}
 {***********************************************************}
 //premire tape, trier la liste
 sortList.QuickSortBy(cAtt.AttToDisc);
 //construire le premier noeud de recherche
 curNode:= TNodeDisc.Create(attY);
 curNode.distY.Refresh(sortList);
 curNode.iMin:= 1;
 curNode.iMax:= sortList.Size;
 //ajouter dans la liste des noeuds
 FLstNodesDisc.Add(curNode);
 //*****************************************************
 //lancer la procdure pseudo-rcursive
 //*****************************************************
 i_curNode:= 0;
 i_maxNode:= 0;
 REPEAT
  curNode:= FLstNodesDisc.Items[i_curNode] as TNodeDisc;
  if getCutPoint(attY,cAtt,curNode,sortList,newNode)
   then
    begin
     if (i_curNode = i_MaxNode)
      then FLstNodesDisc.Add(newNode)
      //insertion juste aprs celui qui vient d'tre split
      else FLstNodesDisc.Insert(succ(i_curNode),newNode);
     //plutt qu'un accs  la liste, on sait que a ne peut augmenter que de 1
     inc(i_maxNode);
    end
   else inc(i_curNode);
 UNTIL (i_curNode > i_maxNode);
 //*****************************************************
 //rcuprer les cut-points
 //*****************************************************
 for i:= 0 to FLstNodesDisc.Count-2 do
  begin
   curNode:= FLstNodesDisc.Items[i] as TNodeDisc;
   //calculer le cutpoint
   leftPoint:= cAtt.AttToDisc.cValue[sortList.Number[curNode.iMax]];
   rightPoint:= cAtt.AttToDisc.cValue[sortList.Number[succ(curNode.iMax)]];//normal, c'est le suivant si la liste est bien faite
   cutPoint:= 0.5*(leftPoint+rightPoint);
   //ajouter dans la liste
   cAtt.addCutPoint(cutPoint);
  end;
end;

function TOpFCDiscMDLPC.shannon(dist: TTabFrequence): double;
var i: integer;
    value: double;
    sum: double;
begin
 sum:= 0.0;
 if (dist.Value[0]>0)
  then
   begin
    for i:= 1 to dist.Size do
     begin
      value:= dist.Frequence[i];
      if (value>0)
       then sum:= sum+value*log2(value);
     end;
   end;
 //on multiplie par -1.0 pour obtenir une entropie positive !!!
 result:= -1.0*sum;
end;

{ TOpPrmFCDiscMDLPC }

function TOpPrmFCDiscMDLPC.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

procedure TOpPrmFCDiscMDLPC.SetDefaultParameters;
begin
 //pas de paramtres
end;

{ TNodeDisc }

constructor TNodeDisc.Create(attY: TAttDiscrete);
begin
 inherited Create();
 distY:= TTabFrequence.CreateFromAtt(attY,nil);
end;

destructor TNodeDisc.Destroy;
begin
 distY.Free();
 inherited destroy();
end;

initialization
 RegisterClass(TGenFCDiscMDLPC);
end.
