(*******************************************************************)
(* UCompFSDefineStatus.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*******************************************************************)

{
@abstract(Dfinition du statut des attributs - target/input/illustrative)
@author(Ricco)
@created(12/01/2004)
}
unit UCompFSDefineStatus;

interface

USES
        Forms, Classes,
        IniFiles,
        UCompDefinition,
        UCompFSDEfinition,
        UOperatorDefinition,
        UDatasetImplementation;

TYPE
        {gnrateur de composant}
        TMLGenFSDefStatus = class(TMLGenComp)
                            protected
                            procedure   GenCompInitializations(); override;
                            public
                            function    GetClassMLComponent: TClassMLComponent; override;
                            end;

        {composant}
        TMLCompFSDefStatus = class(TMLCompFS)
                             protected
                             function    getClassOperator: TClassOperator; override;
                             function    GetLogResultDescription(): string; override;
                             end;

        {oprateur}
        TOpFSDefStatus = class(TOperatorFS)
                          private
                          FLstTarget,FLstInput,FLstIllus: TStringList;
                          procedure   SaveStrListToStream(prmLstStr: TStringList; prmStream: TStream);
                          procedure   LoadStrListFromStream(prmLstStr: TStringList; prmStream: TStream);
                          procedure   SaveStrListToINI(prmSection,prmGenericName: string; prmLst: TStringList; prmINI: TMemIniFile);
                          procedure   LoadStrListFromINI(prmSection,prmGenericName: string; prmLst: TStringList; prmINI: TMemIniFile);
                          protected
                          function    getClassParameter: TClassOperatorParameter; override;
                          function    getStrList(prmAtSt: TEnumAttStatus): TStringList;
                          procedure   SaveOperatorInfoToStream(prmStream: TStream); override;
                          procedure   LoadOperatorInfoFromStream(prmStream: TStream); override;
                          procedure   SaveOperatorInfoToINI(prmSection: string; prmINI: TMemIniFile); override;
                          procedure   LoadOperatorInfoFromINI(prmSection: string; prmINI: TMemIniFile); override;
                          public
                          constructor Create(AOwner: TObject); override;
                          destructor  Destroy; override;
                          function    CoreExecute(): boolean; override;
                          function    getHTMLResultsSummary(): string; override;
                          property    StrListStatus[aStatus: TEnumAttStatus]: TStringList read getStrList;
                         end;

        {paramtre d'oprateur}
        TOpPrmFSDefStatus = class(TOperatorParameter)
                            protected
                            procedure   SetDefaultParameters(); override;
                            function    CreateDlgParameters(): TForm; override;
                            public
                            function    getHTMLParameters(): string; override;
                            end;


implementation

USES
        SysUtils, UDatasetDefinition, UDlgOpFSDefStatus,
        UConstConfiguration, UStringsResources,
        Windows, ULogFile, UStringAddBuffered;

{ TMLGenFSDefStatus }

procedure TMLGenFSDefStatus.GenCompInitializations;
begin
 FMLComp:= mlcFeatureSelection;
 FMLNumIcon:= 6;
 FMLCompName:= str_comp_name_fs_define_status;
 FMLBitmapFileName:= 'MLFSDefStatus.bmp';
 FMLCompDescription:= 'Define status of attributes for the following components: target, input or illustrative.';
end;

function TMLGenFSDefStatus.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompFSDefStatus;
end;

{ TMLCompFSDefStatus }

function TMLCompFSDefStatus.getClassOperator: TClassOperator;
begin
 result:= TOpFSDefStatus;
end;

function TMLCompFSDefStatus.GetLogResultDescription: string;
begin
 result:= Format('%d all --> %d target, %d input, %d illustrative',[OutputData.LstAtts[asAll].Count,OutputData.LstAtts[asTarget].Count,OutputData.LstAtts[asInput].Count,OutputData.LstAtts[asIllus].Count]);
end;

{ TOpFSDefStatus }

function TOpFSDefStatus.CoreExecute: boolean;
var atst: TEnumAttStatus;
    i: integer;
    att: TAttribute;
begin
 //vider la slection courante
 for atst:= asAll to asIllus do
  outputdata.LstAtts[atst].Clear;
 //pour chaque attribut - tout repose sur la recherche par nom
 //pas de pbm donc mme si le pointeur est perdu en cours de route

 //new -- 13/09/2004 -- mme programme sauf que l'on travaille avec les tables de hachage, le gain de temps est faramineux
 for i:= 0 to pred(workdata.LstAtts[asAll].Count) do
  begin
   att:= workdata.LstAtts[asAll].Attribute[i];
   outputdata.LstAtts[asAll].Add(att);
   if (FLstTarget.IndexOf(att.Name)>=0)
    then outputdata.LstAtts[asTarget].Add(att);
   if (FLstInput.IndexOf(att.Name)>=0)
    then outputdata.LstAtts[asInput].Add(att);
   if (FLstIllus.IndexOf(att.Name)>=0)
    then outputdata.LstAtts[asIllus].Add(att);
  end;
 result:= true;
end;

constructor TOpFSDefStatus.Create(AOwner: TObject);
begin
 inherited Create(AOwner);
 (*
 FLstTarget:= TStringList.Create();
 FLstInput:= TStringList.Create();
 FLstIllus:= TStringList.Create();
 *)
 //new -- 13/09/2004 -- tables de hachage, merci pour l'hritage, rien d'autre n'est  modifier...
 FLstTarget:= THashedStringList.Create();
 FLstInput := THashedStringList.Create();
 FLstIllus := THashedStringList.Create();
end;

destructor TOpFSDefStatus.Destroy;
begin
 FLstIllus.Free;
 FLstInput.Free;
 FLstTarget.Free;
 inherited;
end;

function TOpFSDefStatus.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmFSDefStatus; 
end;

function TOpFSDefStatus.getHTMLResultsSummary: string;
var s: string;
    att: TAttribute;
    i: integer;
    sTarget,sInput,SIllus: string;
    buf: TBufString;
begin
 buf:= TBufString.Create();
 buf.BeginUpdate();
 s:= Format('<P>'+HTML_HEADER_TABLE_RESULT+HTML_TABLE_COLOR_HEADER_GRAY+'<TH>Attribute</TH><TH>%s</TH><TH>%s</TH><TH>%s</TH>',
            [STR_ENUM_ATT_STATUS[asTarget],STR_ENUM_ATT_STATUS[asInput],STR_ENUM_ATT_STATUS[asIllus]]);
 buf.AddStr(s);
 for i:= 0 to pred(OutputData.LstAtts[asAll].Count) do
  begin
   att:= OutputData.LstAtts[asAll].Attribute[i];
   //target
   if assigned(OutputData.LstAtts[asTarget].GetFromName(att.Name))
    then sTarget:= 'yes'
    else sTarget:= '-';
   //input
   if assigned(OutputData.LstAtts[asInput].GetFromName(att.Name))
    then sInput:= 'yes'
    else sInput:= '-';
   //illus
   if assigned(OutputData.LstAtts[asIllus].GetFromName(att.Name))
    then sIllus:= 'yes'
    else sIllus:= '-';
   //et le tout
   s:= Format(HTML_TABLE_COLOR_DATA_GRAY+'<td>%s</td><td>%s</td><td>%s</td><td>%s</td>',[att.Name,sTarget,sInput,sIllus]);
   buf.AddStr(s);
  end;
 s:= '</table>';
 buf.AddStr(s);
 buf.EndUpdate();
 //result:= s;
 result:= buf.BufS;
 buf.Free();
end;

function TOpFSDefStatus.getStrList(prmAtSt: TEnumAttStatus): TStringList;
begin
 case prmAtSt of
  asTarget: result:= FLstTarget;
  asInput: result:= FLstInput;
  asIllus: result:= FLstIllus
  else result:= nil;
 end;
end;

procedure TOpFSDefStatus.LoadOperatorInfoFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 self.LoadStrListFromINI(prmSection,'target_',FLstTarget,prmINI);
 self.LoadStrListFromINI(prmSection,'input_',FLstInput,prmINI);
 self.LoadStrListFromINI(prmSection,'illus_',FLstIllus,prmINI);
end;

procedure TOpFSDefStatus.LoadOperatorInfoFromStream(prmStream: TStream);
begin
 self.LoadStrListFromStream(FLstTarget,prmStream);
 self.LoadStrListFromStream(FLstInput,prmStream);
 self.LoadStrListFromStream(FLstIllus,prmStream);
end;

procedure TOpFSDefStatus.LoadStrListFromINI(prmSection,
  prmGenericName: string; prmLst: TStringList; prmINI: TMemIniFile);
var n,i: integer;
    s: string;
begin
 n:= prmINI.ReadInteger(prmSection,prmGenericName+'count',0);
 for i:= 1 to n do
  begin
   s:= prmINI.ReadString(prmSection,prmGenericName+inttostr(i),'');
   if (s<>'')
    then prmLst.Add(s);
  end;
end;

procedure TOpFSDefStatus.LoadStrListFromStream(prmLstStr: TStringList; prmStream: TStream);
var n,i,l: integer;
    s: string;
begin
 prmStream.ReadBuffer(n,sizeof(n));
 for i:= 0 to pred(n) do
  begin
   prmStream.ReadBuffer(l,sizeof(l));
   setlength(s,l);
   prmStream.ReadBuffer(s[1],l);
   prmLstStr.Add(s);
  end;
end;

procedure TOpFSDefStatus.SaveOperatorInfoToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 self.SaveStrListToINI(prmSection,'target_',FLstTarget,prmINI);
 self.SaveStrListToINI(prmSection,'input_',FLstInput,prmINI);
 self.SaveStrListToINI(prmSection,'illus_',FLstIllus,prmINI);
end;

procedure TOpFSDefStatus.SaveOperatorInfoToStream(prmStream: TStream);
begin
 self.SaveStrListToStream(FLstTarget,prmStream);
 self.SaveStrListToStream(FLstInput,prmStream);
 self.SaveStrListToStream(FLstIllus,prmStream);
end;

procedure TOpFSDefStatus.SaveStrListToINI(prmSection,
  prmGenericName: string; prmLst: TStringList; prmINI: TMemIniFile);
var n,i: integer;
begin
 n:= prmLst.Count;
 prmINI.WriteInteger(prmSection,prmGenericName+'count',n);
 for i:= 1 to n do
  prmINI.WriteString(prmSection,prmGenericName+inttostr(i),prmLst[pred(i)]);
end;

procedure TOpFSDefStatus.SaveStrListToStream(prmLstStr: TStringList; prmStream: TStream);
var n,i,l: integer;
    s: string;
begin
 n:= prmLstStr.Count;
 prmStream.WriteBuffer(n,sizeof(n));
 for i:= 0 to pred(n) do
  begin
   s:= prmLstStr[i];
   l:= length(s);
   prmStream.WriteBuffer(l,sizeof(l));
   prmStream.WriteBuffer(s[1],l);
  end;
end;

{ TOpPrmFSDefStatus }

function TOpPrmFSDefStatus.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmFSDefStatus.CreateFromOpPrm(self);
end;

function TOpPrmFSDefStatus.getHTMLParameters: string;
var s: string;
begin
 s:= format('<P><B>%s</B> : %d<BR>',[STR_ENUM_ATT_STATUS[asTarget],(Operator as TOpFSDefStatus).StrListStatus[asTarget].Count]);
 s:= s+format('<B>%s</B> : %d<BR>',[STR_ENUM_ATT_STATUS[asInput],(Operator as TOpFSDefStatus).StrListStatus[asInput].Count]);
 s:= s+format('<B>%s</B> : %d<BR>',[STR_ENUM_ATT_STATUS[asIllus],(Operator as TOpFSDefStatus).StrListStatus[asIllus].Count]);
 result:= s;
end;

procedure TOpPrmFSDefStatus.SetDefaultParameters;
begin
 //rien...
end;

initialization
 Classes.RegisterClass(TMLGenFSDefStatus);
end.
