(*********************************************************************)
(* UCompFSInputSelection.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*********************************************************************)

{
@abstract(Composant gnrique pour les suppression dans les INPUT)
@author(Ricco)
@created(12/05/2004)

}

unit UCompFSInputSelection;

interface

USES
        Classes, Forms,
        UCompFSDefinition,
        UOperatorDefinition;


TYPE
        {composant gnrique de slection des INPUT}
        TMLCompFSInputSelection = class(TMLCompFS)
                                  protected
                                  {ajouter les autres listes d'attributs}
                                  procedure  RefreshOutput(); override;
                                  function   GetLogResultDescription(): string; override;
                                  end;

        {oprateur gnrique de slection des INPUT}
        TOperatorFSInputSelection = class(TOperatorFS)
                                    private
                                    {les attributs extraites de la slection INPUT}
                                    FRemovedFromInput: TStringList;
                                    protected
                                    function    CanExecute(): TEnumErrCanExecute; override;
                                    public
                                    constructor Create(AOwner: TObject); override;
                                    destructor  Destroy(); override;
                                    function    getHTMLResultsSummary(): string; override;
                                    property    RemovedFromInput: TStringList read FRemovedFromInput;
                                    end;

        {paramtrage}
        TOpPrmFSInputSelection = class(TOperatorParameter)
                                 protected
                                 procedure   SetDefaultParameters(); override;
                                 function    CreateDlgParameters(): TForm; override;
                                 end;

        {oprateur gnrique pour mthode supervise}
        TOperatorFSInputSelSupervised = class(TOperatorFSInputSelection)
                                        protected
                                        function    CheckAttributes(): boolean; override;
                                        end;

        {oprateur gnrique, supervis et INPUT tous discrets -- nos mthodes en gros}
        TOpFSInputSelSpvInputDiscrete = class(TOperatorFSInputSelSupervised)
                                        protected
                                        function    CheckAttributes(): boolean; override;
                                        end;

        {oprateur gnrique, supervis et INPUT tous continus}
        TOpFSInputSelSpvInputContinuous = class(TOperatorFSInputSelSupervised)
                                          protected
                                          function    CheckAttributes(): boolean; override;
                                          end;




implementation

uses
        SysUtils,
        UDatasetDefinition,
        UDatasetImplementation, UConstConfiguration, UStringAddBuffered;

constructor TOperatorFSInputSelection.Create(AOwner: TObject);
begin
 inherited Create(AOwner);
 FRemovedFromInput:= TStringList.Create();
end;

destructor TOperatorFSInputSelection.Destroy;
begin
 FRemovedFromInput.Free();
 inherited;
end;

{ TMLCompFSInputSelection }

function TMLCompFSInputSelection.GetLogResultDescription: string;
begin
 result:= format('[SELECTION -- REMOVE INPUT] >> %d INPUT before, %d INPUT after (on %d examples)',[(self.Operator as TOperatorFSInputSelection).workdata.lstAtts[asInput].Count,outputdata.lstAtts[asInput].Count,(self.Operator as TOperatorFSInputSelection).workdata.Examples.Size]);
end;

procedure TMLCompFSInputSelection.RefreshOutput;
begin
 //ne rien faire puisque c'est l'oprateur qui s'en est charg
end;

{ TOperatorFSInputSelection }

function TOperatorFSInputSelection.CanExecute: TEnumErrCanExecute;
var err: TEnumErrCanExecute;
begin
 err:= inherited CanExecute();
 //copier les donnes pour la sortie, sauf les input
 //simple copie, a ne devrait jamais planter
 if (err = errCanExecNoError)
  then
   begin
    self.OutputData.Copy(self.WorkData);
    //vider les input, c'est l'oprateur hritier qui va se charger des ajouts...
    //...pour les variables qui sont OK
    self.OutputData.LstAtts[asInput].Clear();
    //cette liste peur voluer au gr des excutions
    self.RemovedFromInput.Clear();
   end;
 result:= err;
end;

function TOperatorFSInputSelection.getHTMLResultsSummary: string;
var s: string;
    j: integer;
    buf: TBufString;
    att: TAttribute;
begin
 buf:= TBufString.Create();
 buf.BeginUpdate();
 //le nombre des attributs filtrs
 s:= '<H3>INPUT attribute selection</H3>';
 s:= s+HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_BLUE+'<TH colspan="2">INPUT selection</TH>';
 s:= s+format('%s<TD>Before filtering</TD><TD align="right" width="50">%d</TD></TR>',[HTML_TABLE_COLOR_DATA_BLUE,self.workdata.LstAtts[asInput].Count]);
 s:= s+format('%s<TD>After filtering</TD><TD align="right" width="50">%d</TD></TR>',[HTML_TABLE_COLOR_DATA_BLUE,self.outputdata.LstAtts[asInput].Count]);
 s:= s+'</table>';
 buf.AddStr(s);
 //la liste des lus
 s:= '<H3>Keeped into INPUT selection</H3>';
 s:= s+HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan="2">Attributes</TH>';
 buf.AddStr(s);
 for j:= 0 to pred(self.OutputData.LstAtts[asInput].Count) do
  begin
   att:= self.OutputData.LstAtts[asInput].Attribute[j];
   s:= format('%s<TD>%d</TD><TD width="150" align="right">%s</TD></TR>',[HTML_TABLE_COLOR_DATA_GRAY,succ(j),att.Name]);
   buf.AddStr(s);
  end;
 s:= '</table>';
 buf.AddStr(s);
 //new -- 15/09/2004 -- pas ncessaire et trop lourd lorsque le nombre de candidats est lev
 (*
 //la liste des exclus
 s:= '<H3>Removed from INPUT selection</H3>';
 s:= s+HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan="2">Attributes</TH>';
 buf.AddStr(s);
 for j:= 0 to pred(self.RemovedFromInput.Count) do
  begin
   s:= format('%s<TD>%d</TD><TD width="150" align="right">%s</TD></TR>',[HTML_TABLE_COLOR_DATA_GRAY,succ(j),self.RemovedFromInput.Strings[j]]);
   buf.AddStr(s);
  end;
 *)
 s:= '</table>';
 buf.AddStr(s);
 //result:= s;
 buf.EndUpdate();
 result:= buf.BufS;
 buf.Free();
end;

{ TOpPrmFSInputSelection }

function TOpPrmFSInputSelection.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

procedure TOpPrmFSInputSelection.SetDefaultParameters;
begin
 //rien...
end;


{ TOperatorFSInuptSelSupervised }

function TOperatorFSInputSelSupervised.CheckAttributes: boolean;
begin
 result:= (self.WorkData.LstAtts[asTarget].Count=1) and self.WorkData.LstAtts[asTarget].isAllCategory(caDiscrete);
end;

{ TOpFSInputSelSpvInputDiscrete }

function TOpFSInputSelSpvInputDiscrete.CheckAttributes: boolean;
begin
 result:= inherited CheckAttributes()
          and ((self.WorkData.LstAtts[asInput].Count>0) and self.WorkData.LstAtts[asInput].isAllCategory(caDiscrete));
end;

{ TOpFSInputSelSpvInputContinuous }

function TOpFSInputSelSpvInputContinuous.CheckAttributes: boolean;
begin
 result:= inherited CheckAttributes()
          and ((self.WorkData.LstAtts[asInput].Count>0) and self.WorkData.LstAtts[asInput].isAllCategory(caContinue));
end;

end.
