unit UDlgOpFSUnivariateChi2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls,
  LMDCustomControl, LMDCustomPanel, LMDCustomBevelPanel, LMDBaseEdit,
  LMDCustomEdit, LMDCustomMaskEdit, LMDMaskEdit, lmdstdcA;

type
  TDlgOpPrmUnivChi2 = class(TDlgBaseOperatorParameter)
    rgPrmChi2: TRadioGroup;
    edPValue: TLMDMaskEdit;
    edTschuprow: TLMDMaskEdit;
    spinBest: TLMDSpinEdit;
    Label1: TLabel;
    cmbCriterion: TComboBox;
    procedure rgPrmChi2Click(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;    
  end;

var
  DlgOpPrmUnivChi2: TDlgOpPrmUnivChi2;

implementation

uses UCompFSUnivariateChi2;

{$R *.dfm}

procedure TDlgOpPrmUnivChi2.ApplyModifications;
var prm: TOpPrmFSUnivChi2;
begin
 prm:= self.OpPrm as TOpPrmFSUnivChi2;
 prm.UsedStatistic:= self.cmbCriterion.ItemIndex;
 prm.ActivePrm:= self.rgPrmChi2.ItemIndex;
 prm.PValue:= strtofloat(self.edPValue.Text);
 prm.Statistic:= strtofloat(self.edTschuprow.Text);
 prm.XBest:= self.spinBest.Value;
end;

procedure TDlgOpPrmUnivChi2.rgPrmChi2Click(Sender: TObject);
begin
 //classic of classical man...
 self.edPValue.Enabled:= FALSE;
 self.edTschuprow.Enabled:= FALSE;
 self.spinBest.Enabled:= FALSE;
 case rgPrmChi2.ItemIndex of
  0: self.edPValue.Enabled:= TRUE;
  1: self.edTschuprow.Enabled:= TRUE
  else self.spinBest.Enabled:= TRUE;
 end;
end;

procedure TDlgOpPrmUnivChi2.SetParameters;
var prm: TOpPrmFSUnivChi2;
begin
 prm:= self.OpPrm as TOpPrmFSUnivChi2;
 self.cmbCriterion.ItemIndex:= prm.UsedStatistic;
 self.rgPrmChi2.ItemIndex:= prm.ActivePrm;
 self.edPValue.Text:= floattostr(prm.PValue);
 self.edTschuprow.Text:= floattostr(prm.Statistic);
 self.spinBest.Value:= prm.XBest;
end;

end.
