unit UDlgOpPrmISAttributeValue;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls;

type
  TDlgOpPrmISAttributeValue = class(TDlgBaseOperatorParameter)
    Label1: TLabel;
    cmbAttribute: TComboBox;
    Label2: TLabel;
    cmbValue: TComboBox;
    procedure cmbAttributeChange(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;
  end;

var
  DlgOpPrmISAttributeValue: TDlgOpPrmISAttributeValue;

implementation

uses UCompISAttributeValue, UDatasetDefinition, UDatasetImplementation;

{$R *.dfm}

{ TDlgOpPrmISAttributeValue }

procedure TDlgOpPrmISAttributeValue.ApplyModifications;
var prm: TOpPrmISAttValue;
begin
 prm:= OpPrm as TOpPrmISAttValue;
 prm.AttName:= self.cmbAttribute.Text;
 prm.AttValue:= self.cmbValue.Text;
end;

procedure TDlgOpPrmISAttributeValue.SetParameters;
var prm: TOpPrmISAttValue;
    operator: TOpISAttValue;
    att: TAttribute;
    j,idAtt: integer;
begin
 prm:= OpPrm as TOpPrmISAttValue;
 operator:= prm.Operator as TOpISAttValue;
 //lister les attributs candidats dans la combo-box
 cmbAttribute.Items.Clear();
 idAtt:= -1;
 for j:= 0 to pred(operator.WorkData.LstAtts[asAll].Count) do
  begin
   att:= operator.WorkData.LstAtts[asAll].Attribute[j];
   if att.isCategory(caDiscrete)
    then
     begin
       if (att.Name = prm.AttName) then idAtt:= j;
       self.cmbAttribute.Items.AddObject(att.Name,att);
     end;
  end;
 self.cmbAttribute.ItemIndex:= idAtt;
 self.cmbAttributeChange(NIL);
end;

procedure TDlgOpPrmISAttributeValue.cmbAttributeChange(Sender: TObject);
var att: TAttribute;
    sValue: string;
    k,idValue: integer;
begin
 if (self.cmbAttribute.ItemIndex>=0)
  then
   begin
    att:= self.cmbAttribute.Items.Objects[self.cmbAttribute.ItemIndex] as TAttribute;
    self.cmbValue.Items.Clear();
    idValue:= -1;
    for k:= 1 to att.LstValues.getNbValues() do
     begin
      sValue:= att.LstValues.getDescription(k);
      if (sValue = (OpPrm as TOpPrmISAttValue).AttValue)
       then idValue:= pred(k);
      self.cmbValue.Items.Add(sValue);
     end;
    self.cmbValue.ItemIndex:= idValue;
   end;
end;

end.
