(**********************************************************************)
(* UCompISRecoverExamples.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(**********************************************************************)

{
@abstract(Composant recouvrir les exemples)
@author(Ricco)
@created(12/01/2004)
Ce composant peut tre utile par exemple pour simuler le comportement d'un fichier test
lors d'une analyse supervise, il se peut aussi qu'un calcul pralable soit effectu sur
un sous-ensemble d'individus et que par la suite on lance un calcul sur la totalit.
ex. clustering sur un echantillon pour construire des groupes, apprentissage supervis pour reconnatre
les groupes.
}
unit UCompISRecoverExamples;

interface

USES
        Forms,Classes,IniFiles,
        UCompDefinition,
        UCompISSampling,
        UoperatorDefinition;

TYPE
        {gnrateur de composant Strat.Sampling}
        TMLGenCompISRecoverExamples = class(TMLGenComp)
                                      protected
                                      procedure   GenCompInitializations(); override;
                                      public
                                      function    GetClassMLComponent: TClassMLComponent; override;
                                      end;

        {composant sampling}
        TMLCompISRecovExamples = class(TMLCompSampling)
                                 protected
                                 function    getClassOperator: TClassOperator; override;
                                 end;

        {oprateur associ}
        TOpISRecovExamples    = class(TOpSampling)
                                protected
                                function    getClassParameter: TClassOperatorParameter; override;
                                function    CoreExecute(): boolean; override;
                                end;

        {paramtre de l'oprateur associ}
        TOpPrmISRecovExamples = class(TOperatorParameter)
                                private
                                {les individus  recouvrir :
                                0 -> tous,
                                1 -> les nons slectionns}
                                FRecovPrm: integer;
                                protected
                                procedure   SetDefaultParameters(); override;
                                function    CreateDlgParameters(): TForm; override;
                                public
                                function    getHTMLParameters(): string; override;
                                procedure   LoadFromStream(prmStream: TStream); override;
                                procedure   SaveToStream(prmStream: TStream); override;
                                procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                                procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                                property    RecovPrm: integer read FRecovPrm write FRecovPrm;
                                end;

implementation

uses
        UStringsResources,
        SysUtils, UDatasetDefinition, Eigen, UDatasetExamples,
  UDatasetImplementation, UDlgOpPrmISRecoverExamples;

{ TMLGenCompISRecoverExamples }

procedure TMLGenCompISRecoverExamples.GenCompInitializations;
begin
 FMLComp:= mlcInstanceSelection;
 //FMLNumIcon:= 28;
 //FMLCompName:= str_comp_name_is_recover_examples;
 //FMLBitmapFileName:= 'MLSamplingRecoverExamples.bmp';
end;

function TMLGenCompISRecoverExamples.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompISRecovExamples;
end;

{ TMLCompISRecovExamples }

function TMLCompISRecovExamples.getClassOperator: TClassOperator;
begin
 result:= TOpISRecovExamples;
end;

{ TOpISRecovExamples }

function TOpISRecovExamples.CoreExecute: boolean;
var prm: TOpPrmISRecovExamples;
    exOut: TExamples;
begin
 prm:= PrmOp as TOpPrmISRecovExamples;
 case prm.RecovPrm of
  //le plus simple, reprendre tout le monde
  0: begin
      OutputData.Examples.Size:= OutputData.LstAtts[asAll].Size;
      OutputData.Examples.Initialize();//numroter de 1  n
     end
  else
   //recouvrir les non slectionns -- il faut le faire en O(n), le tri est en nlog(n)
   begin
    exOut:= Workdata.Examples.getComplementaire(Workdata.LstAtts[asAll].Size);
    OutputData.Examples.Copy(exOut);
    exOut.Free();
   end;
 end;
 result:= (self.OutputData.Examples.Size>0);
end;

function TOpISRecovExamples.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmISRecovExamples;
end;

{ TOpPrmISRecovExamples }

function TOpPrmISRecovExamples.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmISRecoverExamples.CreateFromOpPrm(self);
end;

function TOpPrmISRecovExamples.getHTMLParameters: string;
var s: string;
begin
 s:= '<P>Examples to recover : ';
 if (FRecovPrm = 0)
  then s:= s+'all'
  else s:= s+'unselected';
 s:= s+'<BR>';
 result:= s;
end;

procedure TOpPrmISRecovExamples.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FRecovPrm:=  prmINI.ReadInteger(prmSection,'recov_prm',FRecovPrm);
end;

procedure TOpPrmISRecovExamples.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FRecovPrm,sizeof(FRecovPrm));
end;

procedure TOpPrmISRecovExamples.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'recov_prm',FRecovPrm);
end;

procedure TOpPrmISRecovExamples.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FRecovPrm,sizeof(FRecovPrm));
end;

procedure TOpPrmISRecovExamples.SetDefaultParameters;
begin
 FRecovPrm:= 1;
end;

initialization
 RegisterClass(TMLGenCompISRecoverExamples);
end.
