(*************************************************************************)
(* UCompISStratifiedSampling.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*************************************************************************)

{
@abstract(Echantillonnage stratifi)
@author(Ricco)
@created(12/01/2004)
}
unit UCompISStratifiedSampling;

interface

USES
        Forms,
        Classes,
        IniFiles,
        UCompDefinition,
        UCompISSampling,
        UoperatorDefinition;

TYPE
        {gnrateur de composant Strat.Sampling}
        TMLGenCompStratSampling = class(TMLGenComp)
                                  protected
                                  procedure   GenCompInitializations(); override;
                                  public
                                  function    GetClassMLComponent: TClassMLComponent; override;
                                  end;

        {composant sampling}
        TMLCompStratSampling = class(TMLCompSampling)
                               protected
                               function    getClassOperator: TClassOperator; override;
                               end;

        {oprateur associ}
        TOpStratSampling    = class(TOpSampling)
                              protected
                              function    getClassParameter: TClassOperatorParameter; override;
                              function    CoreExecute(): boolean; override;
                              end;

        {paramtre de l'oprateur associ}
        TOpPrmStratSampling = class(TOpPrmSampling)
                              private
                              {type de stratification:
                              0 -> reprsentatif,
                              1 -> quilibr}
                              FStratType: integer;
                              {nom de l'attribut de stratification}
                              FStratAttName: string;
                              protected
                              procedure   SetDefaultParameters(); override;
                              function    CreateDlgParameters(): TForm; override;
                              public
                              function    getHTMLParameters(): string; override;
                              procedure   LoadFromStream(prmStream: TStream); override;
                              procedure   SaveToStream(prmStream: TStream); override;
                              procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                              procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                              property    StratType: integer read FStratType write FStratType;
                              property    StratAttName: string read FStratAttName write FStratAttName;
                              end;


implementation

uses
        Sysutils,
        UStringsResources, UDatasetExamples, UDatasetDefinition,
        UDatasetImplementation, UDlgOpPrmStratSampling;

{ TMLGenCompStratSampling }

procedure TMLGenCompStratSampling.GenCompInitializations;
begin
 FMLComp:= mlcInstanceSelection;
 //FMLNumIcon:= 27;
 //FMLCompName:= str_comp_name_is_strat_sampling;
 //FMLBitmapFileName:= 'MLSamplingStratified.bmp';
end;

function TMLGenCompStratSampling.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompStratSampling;
end;

{ TMLCompStratSampling }

function TMLCompStratSampling.getClassOperator: TClassOperator;
begin
 result:= TOpStratSampling;
end;

{ TOpStratSampling }

function TOpStratSampling.CoreExecute: boolean;
var att: TAttribute;
    exIn,exOut: TExamples;
    outSize,pn: Integer;
begin
 exIn:= self.Workdata.Examples;
 exOut:= self.OutputData.Examples;
 att:= self.WorkData.LstAtts[asAll].GetFromName((prmOp as TOpPrmStratSampling).StratAttName);
 outSize:= 0;
 TRY
 if assigned(att)
  then
   begin
    //effectuer la tranformation ici pour viter la multiplication des cas  grer
    if ((prmOp as TOpPrmStratSampling).SampleType = 0)
     then pn:= trunc(1.0*exIn.Size*(prmOp as TOpPrmStratSampling).Proportion)
     else pn:= (prmOp as TOpPrmStratSampling).Size;
    //selon le type d'chantillonnage demand
    case (prmOp as TOpPrmStratSampling).StratType of
     1 : outSize:= exIn.SamplingBalanced(att,pn,exOut)
     else outSize:= exIn.SamplingRepresentative(att,pn,exOut);
    end;
   end;
 FINALLY
 result:= (outSize>0);
 END;
end;

function TOpStratSampling.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmStratSampling;
end;

{ TOpPrmStratSampling }

function TOpPrmStratSampling.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmStratSampling.CreateFromOpPrm(self);
end;

function TOpPrmStratSampling.getHTMLParameters: string;
var s: string;
begin
 s:= inherited getHTMLParameters();
 s:= s+format('Stratification type : %d<BR>',[FStratType]);
 s:= s+format('Stratification attribute : %s<BR>',[FStratAttName]);
 result:= s;
end;

procedure TOpPrmStratSampling.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 inherited LoadFromINI(prmSection,prmINI);
 FStratType:= prmINI.ReadInteger(prmSection,'strat_type',FStratType);
 FStratAttName:= prmINI.ReadString(prmSection,'strat_att_name',FStratAttName);
end;

procedure TOpPrmStratSampling.LoadFromStream(prmStream: TStream);
var l: integer;
begin
 inherited LoadFromStream(prmStream);
 prmStream.ReadBuffer(FStratType,sizeof(FStratType));
 prmStream.ReadBuffer(l,sizeof(l));
 if (l>0)
  then
   begin
    setLength(FStratAttName,l);
    prmStream.ReadBuffer(FStratAttName[1],l);
   end;
end;

procedure TOpPrmStratSampling.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 inherited SaveToIni(prmSection,prmINI);
 prmINI.WriteInteger(prmSection,'strat_type',FStratType);
 prmINI.WriteString(prmSection,'strat_att_name',FStratAttName);
end;

procedure TOpPrmStratSampling.SaveToStream(prmStream: TStream);
var l: integer;
begin
 inherited SaveToStream(prmStream);
 prmStream.WriteBuffer(FStratType,sizeof(FStratType));
 l:= length(FStratAttName);
 prmStream.WriteBuffer(l,sizeof(l));
 if (l>0)
  then prmStream.WriteBuffer(FStratAttNAme[1],l);
end;

procedure TOpPrmStratSampling.SetDefaultParameters;
begin
 inherited SetDefaultParameters();
 FStratType:= 0;
 FStratAttName:= '';
end;

initialization
 RegisterClass(TMLGenCompStratSampling);
end.
