(*****************************************************************)
(* UDlgOpPrmSampling.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*****************************************************************)

{
@abstract(Bote de paramtrage de l'chantillonnage)
@author(Ricco)
@created(12/01/2004)
}
unit UDlgOpPrmSampling;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, lmdstdcA, UCompISSampling;

type
  TDlgOpPrmSampling = class(TDlgBaseOperatorParameter)
    rgSampleType: TRadioGroup;
    Panel2: TPanel;
    spinProportion: TLMDSpinEdit;
    spinAbsolute: TLMDSpinEdit;
    Label1: TLabel;
    procedure rgSampleTypeClick(Sender: TObject);
  private
  FLocalPrm: TOpPrmSampling;
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  DlgOpPrmSampling: TDlgOpPrmSampling;

implementation

{$R *.dfm}

{ TDlgOpPrmSampling }

procedure TDlgOpPrmSampling.ApplyModifications;
begin
 FLocalPrm.SampleType:= rgSampleType.ItemIndex;
 FLocalPrm.Proportion:= 1.0*spinProportion.Value/100.0;
 FLocalPrm.Size:= spinAbsolute.Value;
end;

procedure TDlgOpPrmSampling.SetParameters;
begin
 FLocalPrm:= OpPrm as TOpPrmSampling;
 rgSampleType.ItemIndex:= FLocalPrm.SampleType;
 spinProportion.Value:= trunc(100.0* FLocalPrm.Proportion);
 spinAbsolute.Value:= FLocalPrm.Size;
end;

procedure TDlgOpPrmSampling.rgSampleTypeClick(Sender: TObject);
begin
 spinProportion.Enabled := FALSE;
 spinAbsolute.Enabled   := FALSE;
 //activer le bon spin
 case rgSampleType.ItemIndex of
  0 : spinProportion.Enabled:= TRUE
  else spinAbsolute.Enabled:= TRUE;
 end;
end;

end.
