(**************************************************************)
(* UFrmOpSampling.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(**************************************************************)

{
@abstract(Fiche de visualisation du rsultat d'un sampling)
@author(Ricco)
@created(19/07/03)
(19/07/03)
}
unit UFrmOpSampling;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBaseOperator, Grids,
  UDatasetImplementation, UCompISSampling;

type
  TFrmOpSampling = class(TFrmBaseOperator)
    StrGridResult: TStringGrid;
  private
  {donnes en entre et en sortie}
  FInputData,FOutputData: TMLDataset;
  {oprateur}
  FLocalOp: TOpSampling;
  public
  procedure   PrepareView(); override;
  end;

var
  FrmOpSampling: TFrmOpSampling;

implementation

uses UCompManageDataset;

{$R *.dfm}

{ TFrmOpSampling }

procedure TFrmOpSampling.PrepareView;
begin
 //rcuprer les bonnes infos
 FLocalOp:= Operator as TOpSampling;
 //il y a forcment un prdeccesseur pour ce type de donnes
 //si la connexion a t accepte, c'est que c'tait un gnrateur de donnes
 FInputData:= ((FLocalOp.MLOwner as TMLCompSampling).Predecessor as TMLCompLocalData).OutputData;
 FOutPutData:= (FLocalOp.MLOwner as TMLCompSampling).OutputData;
 //afficher le pourcentage demand puis les effectifs rels produits
 Caption:= Format('%s (%.2f%s)',[(FLocalOp.MLOwner as TMLCompSampling).Description,(FLocalOp.PrmOp as TOpPrmSampling).Proportion*100.0,'%']);
 //remplir la grille
 with strGridResult do
  begin
   cells[0,0]:= 'Previous size';
   cells[1,0]:= Format('%d',[FInputData.Examples.Size]);
   cells[0,1]:= 'Output size';
   cells[1,1]:= Format('%d',[FOutputData.Examples.Size]);
   cells[0,2]:= 'Proportion';
   cells[1,2]:= Format('%.2f %s',[(FLocalOp.PrmOp as TOpPrmSampling).Proportion*100.0,'%']);
  end;
end;

end.
