(***************************************************************)
(* JFGCompPLS.pas - Copyright (c) 2005 Jean-Franois GRANGE *)
(***************************************************************)

{
@abstract(PLS)
@author(Jean-Franois)
@created(t 2005)

La regression PLS

Rfrence utilise : "La rgression PLS" de TENENHAUS

R.R. -- 06/03/2006 -- rajouter la projection
}

unit JFGCompPLS;

interface

USES
  Classes, Forms,
  IniFiles,
  UCompDefinition,
  UOperatorDefinition,
  UCompManageDataset,
  JFGCalcPLS;

TYPE

    {gnrateur de composant}
    TMLGenCompPLS = class(TMLGenComp)

                protected

                           procedure   GenCompInitializations(); override;

                public

                          function    GetClassMLComponent: TClassMLComponent; override;

    end;

    {composant PLS}
    TMLCompPLS = class(TMLCompLocalData)

                protected

                        function    getClassOperator: TClassOperator; override;
    end;

    {oprateur PLS}
    TOpPLS = class(TOpLocalData)

                private

                    //objet de calcul
                    FCalc: TCalcPLS;

                    //nombre vritable d'axes  produire
                    FTrueNbAxis: integer;

                protected

                    function    CheckAttributes(): boolean; override;
                    function    CoreExecute(): boolean; override;
                    function    getClassParameter: TClassOperatorParameter; override;

                    //new -- R.R. -- 06/03/2006 -- raliser les projections
                    procedure   SetProjections();

                public
                
                    destructor  destroy(); override;
                    function    getHTMLResultsSummary(): string; override;
                    end;

    {paramtrage de l'oprateur PLS}
    TOpPrmPLS = class(TOperatorParameter)

                private

                       {nombre d'axes  crer : 5 par dfaut}
                       FNbAxisCreated: integer;

                       {standardiser les donnes ou pas ( diviser les donnes par l'cart-type ou non)}
                       FStandardize: boolean;

                       //new -- 06/03/2006 -- affichage dtaill (true) ou pas (false)
                       FDetailedResult: boolean;

                protected

                       function    CreateDlgParameters(): TForm; override;
                       procedure   SetDefaultParameters(); override;

                public
                
                       function    getHTMLParameters(): string; override;
                       procedure   LoadFromStream(prmStream: TStream); override;
                       procedure   SaveToStream(prmStream: TStream); override;
                       procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                       procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                       property    NbAxisCreated: integer read FNbAxisCreated write FNbAxisCreated;
                       property    Standardize: boolean read FStandardize write FStandardize;
                       property    DetailedResult: boolean read FDetailedResult write FDetailedResult;
    end;

implementation

uses
       Sysutils,
       UDatasetExamples, UDatasetImplementation, UDatasetDefinition,
  ULogFile, JFGDlgOpPrmPLS, UConstConfiguration;

{ TMLGenCompPLS }

procedure TMLGenCompPLS.GenCompInitializations;

        begin
                FMLComp:= mlcPLS;
        end;

function TMLGenCompPLS.GetClassMLComponent: TClassMLComponent;

        begin
                result:= TMLCompPLS;
        end;

{ TMLCompPLS }

function TMLCompPLS.getClassOperator: TClassOperator;

        begin
                result:= TOpPLS;
        end;

{ TOpPrmPLS }

function TOpPrmPLS.CreateDlgParameters: TForm;
       begin

                result:= TDlgOpPrmPLS.CreateFromOpPrm(self);
        end;

function TOpPrmPLS.getHTMLParameters: string;

        var s: string;

        begin
                s:= HTML_HEADER_TABLE_RESULT;
                s:= s+HTML_TABLE_COLOR_HEADER_BLUE+'<TH colspan=2>PLS parameters</TH></TR>';
                s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<TD>Number of axis</TD><TD align=right>%d</TD></TR>',[FNbAxisCreated]);
                s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<TD>Standardize</TD><TD align=right>%d</TD></TR>',[ord(FStandardize)]);
                s:= s+'</table>';
                result:= s;
        end;

procedure TOpPrmPLS.LoadFromINI(prmSection: string;prmINI: TMemIniFile);

        begin
                FNbAxisCreated:= prmINI.ReadInteger(prmSection,'nb_axis',FNbAxisCreated);
                FStandardize:= prmINI.ReadBool(prmSection,'standardize',FStandardize);
                FDetailedResult:= prmINI.ReadBool(prmSection,'detailed',FDetailedResult);
        end;

procedure TOpPrmPLS.LoadFromStream(prmStream: TStream);

        begin
                prmStream.ReadBuffer(FNbAxisCreated,sizeof(FNbAxisCreated));
                prmStream.ReadBuffer(FStandardize,sizeof(FStandardize));
                prmStream.ReadBuffer(FDetailedResult,sizeof(FDetailedResult));
        end;

procedure TOpPrmPLS.SaveToINI(prmSection: string;prmINI: TMemIniFile);

        begin
                prmINI.WriteInteger(prmSection,'nb_axis',FNbAxisCreated);
                prmINI.WriteBool(prmSection,'standardize',FStandardize);
                prmINI.WriteBool(prmSection,'detailed',FDetailedResult);
        end;

procedure TOpPrmPLS.SaveToStream(prmStream: TStream);

        begin
                prmStream.WriteBuffer(FNbAxisCreated,sizeof(FNbAxisCreated));
                prmStream.WriteBuffer(FStandardize,sizeof(FStandardize));
                prmStream.WriteBuffer(FDetailedResult,sizeof(FDetailedResult));
        end;

procedure TOpPrmPLS.SetDefaultParameters;

        begin
                FNbAxisCreated:= 5;
                FStandardize:= TRUE;
                FDetailedResult:= false;
        end;

{ TOpPLS }

function TOpPLS.CheckAttributes: boolean;

        begin

                result:= (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caQuasiContinue));
        end;

function TOpPLS.CoreExecute: boolean;

        begin

                //vider la memoire
                if assigned(FCalc)then FCalc.Free();

               // Execution
                TRY

                        //vrifier que le nombre d'axes  produire n'est pas suprieure  la dimension)
                        if ((self.PrmOp as TOpPrmPLS).NbAxisCreated>self.WorkData.LstAtts[asInput].Count)
                        then FTrueNbAxis:= self.WorkData.LstAtts[asInput].Count
                        else FTrueNbAxis:= (self.PrmOp as TOpPrmPLS).NbAxisCreated;


                        FCalc:= TCalcPLS.create(self.WorkData.LstAtts[asInput],self.WorkData.LstAtts[asTarget],self.WorkData.Examples,(self.PrmOp as TOpPrmPLS).Standardize,FTrueNbAxis,(self.PrmOp as TOpPrmPLS).DetailedResult);
                        FCalc.runAnalysis(self.WorkData.Examples);

                        //R.R. -- new -- 06/03/2006 -- raliser les projections
                        self.SetProjections();

                        //suite...
                        result:= TRUE;

              EXCEPT

               result:= FALSE;
               END;
        end;

destructor TOpPLS.destroy;

        begin
                if assigned(FCalc)then FCalc.Free();
                inherited destroy();
        end;

function TOpPLS.getClassParameter: TClassOperatorParameter;

        begin
                result:= TOpPrmPLS;
        end;

function TOpPLS.getHTMLResultsSummary: string;

        begin
                result:= FCalc.getHTMLResults();
        end;

//new -- R.R. -- 06/03/2006 -- raliser les projections sur chaque colonne de Y 
procedure TOpPLS.SetProjections;
var i: integer;
    att: TAttribute;
begin
 self.GenAtts.Clear();
 for i:= 1 to self.WorkData.LstAtts[asTarget].Count do
  begin
   att:= TAttContinue.Create(Format('PLS_%d_Axis_%d',[(MLOwner as TMLComponent).Number,i]),WorkData.LstAtts[asAll].Size);
   GenAtts.Add(att);
  end;
 //puis demander leur remplissage par projection dans le nouvel espace
 //TraceLog.WriteToLogFile('[NIPALS] >>> begin projection');
 FCalc.setProjection(GenAtts);
end;

initialization

       RegisterClass(TMLGenCompPLS);
end.


