(****************************************************************)
(* UCompRegMultiple.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(****************************************************************)

{
@abstract(NEW -- Regression multiple  la REGRESS)
@author(Ricco)
@created(12/07/2004)
En prparation du cours d'conomtrie effectu en Licence IDS, le contenu du cours est
rsum dans ce composant. Le programme de REGRESS est repris quasiment tel quel,
l'occupation mmoire -- et la rapidit -- n'est pas optimale mais a doit pouvoir tenir la route, et surtout cela
minimise le temps ncessaire  la validation du code.

new -- 19/07/2004 -- la rgression peut tre sans constante maintenant
new -- 02/08/2005 -- la structure d'appel a t modfie de manire  ce que le calcul soit totalement externalise

}
unit UCompRegMultiple;

interface

USES
        Forms,Classes,IniFiles,
        UCompDefinition,
        UOperatorDefinition,
        UCompRegDefinition,
        UDatasetDefinition,
        UCalcStatDesContinuousPlus,
        UCalcRegLinMultiple;

TYPE
        {gnrateur de rgression multiple}
        TGenRegMultiple = class(TMLGenComp)
                          protected
                          procedure   GenCompInitializations(); override;
                          public
                          function    GetClassMLComponent: TClassMLComponent; override;
                          end;

        {composant regression multiple}
        TCompRegMultiple = class(TMLCompRegression)
                           protected
                           function    getClassOperator: TClassOperator; override;
                           function    getGenericAttName(): string; override;
                           end;

        {l'oprateur de rgression multiple}
        TOpRegMultiple = class(TOperatorRegression)
                         private
                         {liste des exognes}
                         FLstExogenous: TLstAttributes;
                         {classe de calcul importe}
                         FCalcReg: TCalcRegMultiple;
                         {Stats sur les rsidus}
                         FEpsilonStat: TCalcStatDesContPlus;
                         protected
                         function    getClassParameter: TClassOperatorParameter; override;
                         {dsalloue le calculateur}
                         procedure   ReInitialize(); override;
                         {tester la validit des attributs}
                         function    CheckAttributes(): boolean; override;
                         {la description de la rgression en HTML}
                         function    getCoefsRegressionHTML(): string;
                         {description des rsidus en HTML}
                         function    getResidualsHTML(): string;
                         public
                         {dfinir une liste d'exognes vide}
                         constructor Create(AOwner: TObject); override;
                         {dtruire la liste d'exogne}
                         destructor  Destroy; override;
                         {excution effective}
                         function    CoreExecute(): boolean; override;
                         {rsum des rsultats}
                         function    getHTMLResultsSummary(): string; override;
                         {liste des exognes}
                         property    LstExogenous: TLstAttributes read FLstExogenous;
                         end;

        {paramtrage de la rgression multiple}
        TOpPrmRegMultiple = class(TOperatorParameter)
                            private
                            {rgression avec constante ou non}
                            FConstant: boolean;
                            protected
                            procedure   SetDefaultParameters(); override;
                            function    CreateDlgParameters(): TForm; override;
                            public
                            function    getHTMLParameters(): string; override;
                            procedure   LoadFromStream(prmStream: TStream); override;
                            procedure   SaveToStream(prmStream: TStream); override;
                            procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                            procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                            property    Constant: Boolean read FConstant write FConstant;
                            end;

implementation

uses
        FMath,
        Sysutils, Windows, ULogFile,
        UDatasetImplementation, Models, UConstConfiguration,
        UStringsResources, UStringAddBuffered, UDlgOpPrmRegMultiple;

{ TGenRegMultiple }

procedure TGenRegMultiple.GenCompInitializations;
begin
 FMLComp:= mlcRegression;
end;

function TGenRegMultiple.GetClassMLComponent: TClassMLComponent;
begin
 result:= TCompRegMultiple;
end;

{ TCompRegMultiple }

function TCompRegMultiple.getClassOperator: TClassOperator;
begin
 result:= TOpRegMultiple;
end;

function TCompRegMultiple.getGenericAttName: string;
begin
 result:= 'lmreg';
end;

{ TOpRegMultiple }

function TOpRegMultiple.CheckAttributes: boolean;
var ok: boolean;
begin
 ok:= inherited CheckAttributes();
 //vrifier que les exognes sont tous continus
 ok:= ok and (workdata.LstAtts[asInput].isAllCategory(caContinue));
 //vrifier que la taille de l'chantillon est suprieur au nombre de variables
 ok:= ok and (workdata.Examples.Size > workdata.LstAtts[asInput].Count);
 //rcuprer dans les champs internes
 if ok
  then
   begin
    FLstExogenous.Clear();
    FLstExogenous.Assign(workdata.LstAtts[asInput]);
   end;
 result:= ok;
end;

function TOpRegMultiple.CoreExecute: boolean;
begin
 //init.
 result:= FALSE;
 //vider
 if assigned(FCalcReg) then FreeAndNil(FCalcReg);
 if assigned(FEpsilonStat) then FreeAndNil(FEpsilonStat);
 //puis crer et excuter l'objet de calcul en passant les donnes en paramtres
 FCalcReg:= TCalcRegMultiple.create(self.Endogenous,self.LstExogenous,(self.PrmOp as TOpPrmRegMultiple).Constant);
 if FCalcReg.execute(self.WorkData.Examples)
  then
   begin
    //projection et calcul des rsidus -- la taille des attributs est suppose correcte -- cf. "procedure TMLCompRegression.InitializeDataset;"
    FCalcReg.Predict(self.EndoPred,self.ErrPred);
    //calculer les stats sur les rsidus
    FEpsilonStat:= TCalcStatDesContPlus.Create(self.ErrPred,self.WorkData.Examples);
    //et donc, tout est bien
    result:= TRUE;
   end;
end;

constructor TOpRegMultiple.Create(AOwner: TObject);
begin
 inherited Create(AOwner);
 FLstExogenous:= TLstAttributes.Create(FALSE,Workdata.LstAtts[asAll].Size);
end;

destructor TOpRegMultiple.Destroy;
begin
 FLstExogenous.Free;
 inherited Destroy;
end;

function TOpRegMultiple.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmRegMultiple;
end;

function TOpRegMultiple.getCoefsRegressionHTML: string;
begin
 if assigned(FCalcReg)
  then result:= FCalcReg.GetHTMLResult()
  else result:= '';
end;

function TOpRegMultiple.getHTMLResultsSummary: string;
begin
 result:= self.getCoefsRegressionHTML() + self.getResidualsHTML();
end;

function TOpRegMultiple.getResidualsHTML: string;
var s: string;
begin
 if assigned(FEpsilonStat)
  then
   begin
    //les stats sur les rsidus
    s:= '<H3>Residuals analysis</H3>';
    s:= s+format('<TABLE class="BodyStyle" cellspacing=2 cellpadding=2 %s>',[HTML_BGCOLOR_DATA_GRAY]);
    s:= s+format('%s<TH>Att. name</TH><TH width="300">Full statistics</TH><TH>Histogram</TH></TR>',[HTML_TABLE_COLOR_HEADER_BLUE]);
    s:= s+FEpsilonStat.getHTMLResult();
    s:= s+'</table>';
    result:= s;
   end
  else result:= '';
end;

procedure TOpRegMultiple.ReInitialize;
begin
 inherited ReInitialize();
 if assigned(FCalcReg)
  then FreeAndNil(FCalcReg);
end;

{ TOpPrmRegMultiple }

function TOpPrmRegMultiple.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmRegressionMultiple.CreateFromOpPrm(self); 
end;

function TOpPrmRegMultiple.getHTMLParameters: string;
var s: string;
begin
 s:= '<P><B>Regression parameters</B><BR>'+HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+'<TD width=120>Include intercept</TD>';
 if FConstant
  then s:= s+format('<TD width=50>%s</TD>',['yes'])
  else s:= s+format('<TD width=50>%s</TD>',['no']);
 s:= s+'</TR></table>';
 result:= s;
end;

procedure TOpPrmRegMultiple.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FConstant:= prmINI.ReadBool(prmSection,'constant',FConstant);
end;

procedure TOpPrmRegMultiple.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FConstant,sizeof(FConstant));
end;

procedure TOpPrmRegMultiple.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteBool(prmSection,'constant',FConstant);
end;

procedure TOpPrmRegMultiple.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FConstant,sizeof(FConstant));
end;

procedure TOpPrmRegMultiple.SetDefaultParameters;
begin
 FConstant:= true;
end;

initialization
 Classes.RegisterClass(TGenRegMultiple);
end.
