(************************************************************)
(* UCalcRegTree.pas - Copyright (c) 2006 Ricco RAKOTOMALALA *)
(************************************************************)

{
@abstract(Arbre de Rgression -- Largement inspir par CART, seule la stratgie d'lagage est diffrente)
@author(Ricco)
@created(14/05/2006)

Utilisation du cadre CART pour construire un arbre de rgression.

A la diffrence de CART, le point d'lagage est fix diffrement, on cherche "le coude" qui prcde
le point optimal dans la courbe de l'inertie intra.

Cette classe est une application  une modalit de la procdure CLUSTERING TREE. Trs peu de modifications
intrinsque donc.
}

unit UCalcRegTree;

interface

USES
    UCalcTreeStructureDefinition,   
    UCalcClusteringTree,
    UCalcClusteringTreeCART,
    UDatasetDefinition;

TYPE
    //classe de noeud de l'arbre
    TMLTreeNodeReg = class(TMLTreeNodeClusCTP)
                     public
                     function   getHTMLLeafInfos(): string; override;
                     function   average(): double;
                     function   stddev(): double;   
                     end;   

    //classe de structure d'arbre
    TMLTreeStructureReg = class(TMLTreeStructureClusCTP)
                          protected
                          function   getClassMLTreeNode(): TClassMLTreeNode; override;  
                          end;

    //oprateur de calcul pour la rgression par arbres
    //driv du culstering (predictif) par arbres
    TCalcRegTreeCTP = class(TCalcClusTreeCTP)
                      protected
                      function  getClassTreeStructure(): TClassMLTreeStrucClus; override;
                      public
                      procedure Predict(prmPred, prmErr: TAttribute);  
                      end;

implementation

USES
    UCalcStatDes,
    Sysutils;

{ TCalcRegTreeCTP }

function TCalcRegTreeCTP.getClassTreeStructure: TClassMLTreeStrucClus;
begin
 result:= TMLTreeStructureReg;
end;

procedure TCalcRegTreeCTP.Predict(prmPred, prmErr: TAttribute);
var i: integer;
    endo: TAttribute;
    leaf: TMLTreeNodeReg;
    value: TTypeContinue; 
begin
 endo:= self.Targets.Attribute[0];
 //construire la prdiction pour chaque exemple et calculer l'erreur
 for i:= 1 to endo.Size do
  begin
   //calcul de la prdiction
   leaf:= self.SetLeafExample(i) as TMLTreeNodeReg;
   if assigned(leaf)
    then value:= leaf.average()
    //si pas couvert (?), on prend la moyenne globale
    else value:= ((self.FTree as TMLTreeStructureReg).RootNode as TMLTreeNodeReg).average();
   //assignation
   prmPred.cValue[i]:= value;
   prmErr.cValue[i]:= endo.cValue[i]-value;
  end;
end;

{ TMLTreeStructureReg }

function TMLTreeStructureReg.getClassMLTreeNode: TClassMLTreeNode;
begin
 result:= TMLTreeNodeReg; 
end;

{ TMLTreeNodeReg }

function TMLTreeNodeReg.average: double;
begin
 result:= (FStats.Stat(0) as TCalcStatDesContinuous).average;
end;

function TMLTreeNodeReg.getHTMLLeafInfos: string;
begin
 result:= format(' then <b>avg(%s) = %.4f</b> (std-dev = %.4f, with %d examples [%.2f%s])',
                [FStats.Stat(0).Attribute.Name,
                 self.average(),self.stddev(),
                 FStats.NbExamples,100.0*FStats.NbExamples/(1.0*(self.TreeStructure as TMLTreeStructureReg).FStats.NbExamples),'%']);
end;

function TMLTreeNodeReg.stddev: double;
begin
 result:= (FStats.Stat(0) as TCalcStatDesContinuous).StdDev;
end;

end.
