(************************************************************)
(* UCompRegTree.pas - Copyright (c) 2006 Ricco RAKOTOMALALA *)
(************************************************************)

{
@abstract(Arbre de Rgression -- Largement inspir par CART, seule la stratgie d'lagage est diffrente)
@author(Ricco)
@created(14/05/2006)

Utilisation du cadre CART pour construire un arbre de rgression.

A la diffrence de CART, le point d'lagage est fix diffrement, on cherche "le coude" qui prcde
le point optimal dans la courbe de l'inertie intra.

Cette classe est une application  une modalit de la procdure CLUSTERING TREE. Trs peu de modifications
intrinsque donc.
}

unit UCompRegTree;

interface

uses
    Forms,
    UCompDefinition,
    UCompRegDefinition,
    UOperatorDefinition,
    UCompClusteringTreeCART,
    UCalcClusteringTreeCART,
    UDatasetDefinition,
    UDatasetImplementation,
    UDatasetExamples,
    UCalcRegTree;

TYPE
    //gnrateur
    TMLGenRegTree = class(TMLGenComp)
                    protected
                    procedure   GenCompInitializations(); override;
                    public
                    function    GetClassMLComponent: TClassMLComponent; override;
                    end;

    //composant
    TMLCompRegTree = class(TMLCompRegression)
                     protected
                     function    getClassOperator: TClassOperator; override;
                     function    getGenericAttName(): string; override;
                     end;

    //oprateur -- attention, la grosse astuce, on passe par la classe de clustering, mais on force la slection d'une seule variable TARGET !
    TOpRegTree = class(TOperatorRegression)
                 private
                 //classe de calcul effectif, c'est en fait un clustering tree qui est en dessous
                 FCalc: TCalcRegTreeCTP;
                 //variable dont les modalits sont les clusters correspondant aux feuilles de l'arbre
                 FClusters: TAttDiscrete;
                 //coefficient de dtermination
                 R2: double;
                 protected
                 function    getClassParameter: TClassOperatorParameter; override;
                 function    CoreExecute(): boolean; override;
                 procedure   evaluation(examples: TExamples);
                 public
                 function    getHTMLResultsSummary(): string; override;
                 destructor  destroy(); override;
                 end;

    //paramtrage
    TPrmOpRegTree = class(TOpPrmClusTreeCART)
                    protected
                    function    CreateDlgParameters(): TForm; override;
                    procedure   SetDefaultParameters(); override;
                    end;
                        

implementation

uses
    Classes, Sysutils, UCompClusteringDefinition, UDlgOpPrmRegressionTree,
    UDlgBaseOperatorParameter, UConstConfiguration, UCalcStatDes;

{ TMLGenRegTree }

procedure TMLGenRegTree.GenCompInitializations;
begin
 FMLComp:= mlcRegression;
end;

function TMLGenRegTree.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompRegTree; 
end;

{ TMLCompRegTree }

function TMLCompRegTree.getClassOperator: TClassOperator;
begin
 result:= TOpRegTree;
end;

function TMLCompRegTree.getGenericAttName: string;
begin
 result:= 'RegTree';
end;

{ TOpRegTree }

function TOpRegTree.CoreExecute: boolean;
begin
 if assigned(FCalc) then FCalc.Free();
 if assigned(FClusters) then FClusters.Free();
 result:= true;
 TRY
 FClusters:= TAttDiscrete.Create('_clus_reg_tree',self.WorkData.LstAtts[asTarget].Size);
 FCalc:= TCalcRegTreeCTP.Create(self.WorkData.LstAtts[asTarget],self.WorkData.LstAtts[asInput],self.PrmOp as TPrmOpRegTree,FClusters);
 FCalc.BuildClusters(self.WorkData.Examples);
 //construire la prdiction
 FCalc.Predict(self.EndoPred,self.ErrPred);
 //valuer la rgression
 self.Evaluation(self.WorkData.Examples);
 EXCEPT
 result:= false;
 END;
end;

destructor TOpRegTree.destroy;
begin
 if assigned(FCalc) then FCalc.Free();
 if assigned(FClusters) then FClusters.Free();
 inherited destroy();
end;

procedure TOpRegTree.evaluation(examples: TExamples);
var statEndo, statResidu: TCalcStatDesContinuous;
begin
 statEndo:= TCalcStatDesContinuous.Create(self.Endogenous,examples);
 statResidu:= TCalcStatDesContinuous.Create(self.ErrPred,examples);
 if (statEndo.TSS > 0.0)
  then R2:= 1.0 - statResidu.TSS / statEndo.TSS
  else R2:= 0.0;
end;

function TOpRegTree.getClassParameter: TClassOperatorParameter;
begin
 result:= TPrmOpRegTree; 
end;

function TOpRegTree.getHTMLResultsSummary: string;
var s: string;
begin
 //rsultats gnraux
 s:= '<H3>Global results</H3>';
 s:= s + HTML_HEADER_TABLE_RESULT;
 s:= s + format('%s<TD width="150">Endogenous attribute</TD><TD align="right" width="150"><B>%s</B></TD></TR>',[HTML_TABLE_COLOR_DATA_BLUE,Endogenous.Name]);
 s:= s + format('%s<TD>Examples</TD><TD align="right">%d</TD></TR>',[HTML_TABLE_COLOR_DATA_BLUE,self.WorkData.Examples.Size]);
 s:= s + format('%s<TD>R</TD><TD align="right">%.4f</TD></TR>',[HTML_TABLE_COLOR_DATA_BLUE,R2]);
 s:= s + '</table>';
 //suite, description de l'arbre
 result:= s + FCalc.GetHTMLResult();
end;

{ TPrmOpRegTree }

function TPrmOpRegTree.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmRegressionTree.CreateFromOpPrm(self);
end;

procedure TPrmOpRegTree.SetDefaultParameters;
begin
  inherited;
  //moins restrictif au dpart sur la pente
  FThresholdSlope:= -0.01;
  FShowAllTreeSeq:= FALSE;
end;

initialization
 Classes.RegisterClass(TMLGenRegTree);
end.
