(******************************************************************)
(* UCompMetaSpvArcing.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(******************************************************************)

{
@abstract(Arcing)
@author(Ricco)
@created(12/01/2004)
}
unit UCompMetaSpvArcing;

interface

USES
        UCompDefinition,
        UCompSpvLDefinition,
        UOperatorDefinition,
        UCompMetaSpvCommitte,
        UDatasetExamples;

TYPE
        {gnrateur de composant meta}
        TMLGCompArcing = class(TMLGenComp)
                          protected
                          procedure   GenCompInitializations(); override;
                          public
                          function    GetClassMLComponent: TClassMLComponent; override;
                          end;

        {le composant meta, singe un single learning}
        TMLCompArcing = class(TMLCompMetaSpvLearning)
                         protected
                         function    ShortMLCompName(): string; override;
                         function    getClassOperator: TClassOperator; override;
                         end;

        {oprateur arcing - driv de arcing, le poids des individus est introduit}
        TOpMetaSpvArcing = class(TOpMetaSpvCommitte)
                            private
                            {Tableau des erreurs cumules des classifieurs pour chaque individu}
                            FTabErrSum: array of double;    
                            protected
                            {vecteur des poids des individus}
                            FWeights: TWeightExamples;
                            {poids cumuls}
                            FWeightsCumulated: TWeightExamples;
                            procedure   prepareCalcData(); override;
                            procedure   destroyCalcData(); override;
                            {tirage avec des probas pondrs}
                            procedure   prepareSample(); override;
                            {calcul de l'erreur et mj des poids}
                            function    getErrorRate(prmExamples: TExamples): double; override;
                            end;

implementation

uses
        Math, Classes,
        UStringsResources, UDatasetDefinition, UCalcDistribution;

{ TMLGCompArcing }

procedure TMLGCompArcing.GenCompInitializations;
begin
 FMLComp:= mlcMetaSpvLearning;
 //FMLNumIcon:= 33;
 //FMLCompName:= str_comp_name_meta_spvl_arcing;
 //FMLBitmapFileName:= 'MLMetaSpvArcing.bmp';
end;

function TMLGCompArcing.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompArcing;
end;

{ TMLCompArcing }

function TMLCompArcing.getClassOperator: TClassOperator;
begin
 result:= TOpMetaSpvArcing;
end;

function TMLCompArcing.ShortMLCompName: string;
begin
 result:= 'Arcing';
end;

{ TOpMetaSpvArcing }

procedure TOpMetaSpvArcing.destroyCalcData;
begin
 inherited destroyCalcData;
 //il est pertinent de dtruire le tableau des poids ici puisque l'on s'en sert pas pour le classement
 //le cas est diffrent pour le boosting
 FWeights.Free;
 FWeightsCumulated.Free;
 setLength(FTabErrSum,0);
end;

function TOpMetaSpvArcing.getErrorRate(prmExamples: TExamples): double;
var i: integer;
    example: integer;
    err,OneErr: double;
    kActual,kPred: TTypeDiscrete;
    //pDist: TTabFrequence;
    classifier: TCalcSpvLearning;
begin
 //dernier classifieur en date
 classifier:= Classifiers.Items[pred(Classifiers.Count)] as TCalcSpvLearning;
 //calcul de l'erreur
 err:= 0.0;
 for i:= 1 to prmExamples.Size do
  begin
   //individu  tester
   example:= prmExamples.Number[i];
   //sa vraie classe
   kActual:= OpMLSpv.ClassAttribute.dValue[example];
   //les classes prdites
   classifier.classification(example,kPred);
   //erreur de prdiction du dernier classifieur induit
   OneErr:= ord(kActual<>kPred);
   //ajouter l'erreur
   err:= err+OneErr;
   //cumul des erreurs sur les classifieurs produits jusqu'ici
   FTabErrSum[i]:= FTabErrSum[i]+OneErr;
   //nouveau poids...Arc-x4
   FWeights.Weight[i]:= 1.0+Power(FTabErrSum[i],4.0);
  end;
 err:= err/(1.0*prmExamples.Size);
 result:= err;
end;

procedure TOpMetaSpvArcing.prepareCalcData;
begin
 inherited prepareCalcData();
 //tableau des poids
 FWeights:= TWeightExamples.Create(FInternalExamples.Size);
 FWeights.Initialize();
 //tableau des poids cumuls
 FWeightsCumulated:= TWeightExamples.Create(FInternalExamples.Size);
 //tableau des erreurs
 setLength(FTabErrSum,succ(workdata.Examples.Size));
end;

procedure TOpMetaSpvArcing.prepareSample;
begin
 //normaliser les poids
 FWeights.Normalize();
 //prparation des poids cumuls
 FWeightsCumulated.Copy(FWeights);
 FWeightsCumulated.CalcCumulated();
 //chantillonnage
 self.WorkData.Examples.SampleReplicateWeighted(FInternalExamples,FWeightsCumulated);
end;

initialization
 RegisterClass(TMLGCompArcing);
end.
