(********************************************************************)
(* UCompMetaSpvCommitte.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(********************************************************************)

{
@abstract(Committe learning de base pour les mthodes d'agrgation)
@author(Ricco)
@created(12/01/2004)
La base est l'article de Bauer&Kohavi, celui de Breiman galement a bcp servi.
}
unit UCompMetaSpvCommitte;

interface

USES
        Contnrs,
        Forms,Classes,IniFiles,
        UDatasetExamples,
        UCompSpvLDefinition,
        UOperatorDefinition,
        UDatasetDefinition,UCalcDistribution,
        UCalcSpvStructScore;

TYPE
        {Oprateur associ}
        TOpMetaSpvCommitte = class(TOpMetaSpvLearning)
                             private
                             {liste des clasiffieurs}
                             FClassifiers: TObjectList;
                             {tableau des taux d'erreur}
                             FTabErrors: array of double;
                             protected
                             {tableau des affectations}
                             //FTabAffectations: array of double;
                             {individus sur lesquels est appliqu l'apprentissage}
                             FInternalExamples: TExamples;
                             {sauf cas contrire, tous les committees ont le mme type de paramtrage}
                             function    getClassParameter: TClassOperatorParameter; override;
                             {lancer les apprentissages successifs}
                             procedure   RunLearning(); override;
                             {vider la liste des classifieurs}
                             procedure   ReInitialize(); override;
                             {supprimer la liste}
                             procedure   destroyClassifiers(); override;
                             {prparer les donnes internes}
                             procedure   prepareCalcData(); virtual;
                             {supprimer les donnes internes}
                             procedure   destroyCalcData(); virtual;
                             {prparer les individus d'chantillonnage}
                             procedure   prepareSample(); virtual; abstract;
                             {rcuprer le taux d'erreur d'un classifieur - calcul rapide - on en profite pour mettre  jour les poids le cas chant}
                             function    getErrorRate(prmExamples: TExamples): double; virtual;
                             {renvoyer les scores d'affectation pour un individu}
                             procedure   resetScore(example: integer; var postProba: TTabScore); override;
                             {vote  la majorit simple au dpart}
                             procedure   ClassifyExample(example: integer; var response: TTypeDiscrete); override;
                             public
                             function    getHTMLResultsSummary(): string; override;
                             {pointeur sur la liste des classifieurs}
                             property Classifiers: TObjectList read FClassifiers;
                             {individus de l'apprentissage courant}
                             property InternalExamples: TExamples read FInternalExamples;
                             end;

        {paramtre de l'oprateur - ils ont en commun le nombre d'instances  produire}
        TOpPrmMetaSpvCommitte = class(TOpPrmMetaSpvLearning)
                                private
                                {nombre d'instances}
                                FNbInstances: integer;
                                protected
                                function  createDlgParameters(): TForm; override;
                                function  getCommitteParameters(): string; virtual;
                                function  getClassifierParameters(): string; virtual;
                                procedure SetDefaultParameters(); override;
                                public
                                function    getHTMLParameters(): string; override;
                                procedure   LoadFromStream(prmStream: TStream); override;
                                procedure   SaveToStream(prmStream: TStream); override;
                                procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                                procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                                {nombre d'instances}
                                property NbInstances: integer read FNbInstances write FNbInstances;
                                end;

implementation

USES
        Sysutils, UConstConfiguration, UDlgOprmMetaSpvCommittee;

{ TOpPrmMetaSpvCommitte }

function TOpPrmMetaSpvCommitte.createDlgParameters: TForm;
begin
 result:= TDlgOpPrmSpvMetaCommittee.CreateFromOpPrm(self);
end;

function TOpPrmMetaSpvCommitte.getClassifierParameters: string;
begin
 result:= (self.Operator as TOpMetaSpvLearning).OpMLSpv.getHTMLParameters();
end;

function TOpPrmMetaSpvCommitte.getCommitteParameters: string;
var s: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Number of classifier(s)</TD><TD width=30 align=right>%d</TD></TR>',[FNbInstances]);
 s:= s+'</table>';
 result:= s;
end;

function TOpPrmMetaSpvCommitte.getHTMLParameters: string;
var s: string;
begin
 s:= '<H3>Committee parameters</H3>';
 s:= s+self.getCommitteParameters();
 s:= s+'<H3>Learning algorithm parameters</H3>';
 s:= s+self.getClassifierParameters();
 result:= s;
end;

procedure TOpPrmMetaSpvCommitte.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FNbInstances:= prmINI.ReadInteger(prmSection,'nb_classifiers',FNbInstances);
end;

procedure TOpPrmMetaSpvCommitte.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FNbInstances,sizeof(FNbInstances));
end;

procedure TOpPrmMetaSpvCommitte.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'nb_classifiers',FNbInstances);
end;

procedure TOpPrmMetaSpvCommitte.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FNbInstances,sizeof(FNbInstances));
end;

procedure TOpPrmMetaSpvCommitte.SetDefaultParameters;
begin
 FNbInstances:= 25;
end;

{ TOpMetaSpvCommitte }

procedure TOpMetaSpvCommitte.destroyClassifiers;
begin
 inherited;
 if assigned(FClassifiers)
  then FreeAndNil(FClassifiers);
 setLength(FTabErrors,0);
 //setLength(FTabAffectations,0);
end;

procedure TOpMetaSpvCommitte.destroyCalcData;
begin
 FreeAndNil(FInternalExamples);
end;

function TOpMetaSpvCommitte.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmMetaSpvCommitte;
end;

procedure TOpMetaSpvCommitte.prepareCalcData;
begin
 FInternalExamples:= TExamples.Create(self.WorkData.Examples.Size);
end;

procedure TOpMetaSpvCommitte.ReInitialize;
begin
 inherited ReInitialize();
 //vider l'ensemble des classifieurs
 if assigned(FClassifiers)
  then FClassifiers.Clear;
end;

procedure TOpMetaSpvCommitte.RunLearning;
var i: integer;
    classifier: TCalcSpvLearning;
    err: double;
begin
 //tout vider
 if assigned(FClassifiers)
  then FreeAndNil(FClassifiers);
 setLength(FTabErrors,succ((self.PrmOp as TOpPrmMetaSpvCommitte).NbInstances));
 //setLength(FTabAffectations,succ(OpMLSpv.ClassAttribute.nbValues));
 //construire
 FClassifiers:= TObjectList.Create(TRUE);
 //prparer les donnes internes
 self.prepareCalcData();
 //lancer les apprentissage successifs
 for i:= 1 to (self.PrmOp as TOpPrmMetaSpvCommitte).NbInstances do
  begin
   //chantillonner les individus
   self.prepareSample();
   //lancer l'apprentissage
   classifier:= OpMLSpv.getInstanceSpvLearning();
   classifier.learning(FInternalExamples);
   //ajouter le classifieur dans la liste - trs important de le faire avant le calcul du taux d'erreur
   FClassifiers.Add(classifier);
   //calculer le taux d'erreur
   err:= self.getErrorRate(self.WorkData.Examples);
   FTabErrors[i]:= err;
  end;
 //supprimer les donnes internes
 self.destroyCalcData();
end;

function TOpMetaSpvCommitte.getErrorRate(prmExamples: TExamples): double;
var i: integer;
    example: integer;
    err: double;
    kActual,kPred: TTypeDiscrete;
    //pDist: TTabFrequence;
    classifier: TCalcSpvLearning;
begin
 //on prend le dernier classifieur
 classifier:= FClassifiers.Items[pred(FClassifiers.Count)] as TCalcSpvLearning;
 //on l'value
 err:= 0.0;
 for i:= 1 to prmExamples.Size do
  begin
   example:= prmExamples.Number[i];
   kActual:= OpMLSpv.ClassAttribute.dValue[example];
   classifier.classification(example,kPred);
   err:= err+integer(kActual<>kPred);
  end;
 err:= err/(1.0*prmExamples.Size);
 result:= err;
end;

procedure TOpMetaSpvCommitte.resetScore(example: integer;
  var postProba: TTabScore);
var i: integer;
    kPred: TTypeDiscrete;
begin
 //vider le tableau d'affectation
 postProba.raz();
 //enquiller les diffrentes rponses
 for i:= 0 to pred(FClassifiers.Count) do
  begin
   (FClassifiers.Items[i] as TCalcSpvLearning).classification(example,kPred);
   postProba[kPred]:= postProba[kPred]+1.0;
  end;
 //normaliser -- inutile ici car on le fait systmatiquement dans les mthodes appellantes
 //postProba.normalize();
end;

procedure TOpMetaSpvCommitte.ClassifyExample(example: integer;
  var response: TTypeDiscrete);
begin
 //calculer les probas d'affectation
 self.resetScore(example,FPostProba);
 //renvoyer l'indice du max.
 response:= FPostProba.getIndexMax();
end;

function TOpMetaSpvCommitte.getHTMLResultsSummary: string;
var s: string;
    i: integer;
begin
 s:= inherited getHTMLResultsSummary();
 //tableau des taux d'erreur
 s:= s+'<h4>Classifiers performances</h4>';
 s:= s+HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH>Classifiers</TH><TH>Error rate</TH></TR>';
 for i:= 1 to high(FTabErrors) do
  s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD align=center>%d</TD><TD align=right>%.4f</TD></TR>',[i,FTabErrors[i]]);
 s:= s+'</table>';
 result:= s;
end;

end.
