(******************************************************************************)
(* UCompMetaSpvGenericAggregating.pas - Copyright (c) 2006 Ricco RAKOTOMALALA *)
(******************************************************************************)

{
@abstract(Composant gnrique pour l'agrgation de classifieurs)
@author(Ricco)
@created(08/03/2006)

Prparation travail de stage au Laboratoire ERIC -- Mars 2006

Pour s'inspirer des solutions selon les pondrations et le mode de combinaison des classifieurs,  voir...

--> UCompMetaSpvCommitte (classe de base, anctre)
--> UCompMetaSpvBagging (Breiman)
--> UCompMetaSpvArcing (Breiman)
--> UCompMetaSpvBoosting (Freund & Schapire)

}

unit UCompMetaSpvGenericAggregating;

interface


USES
        UCompDefinition,
        UCompSpvLDefinition,
        UOperatorDefinition,
        UCompMetaSpvCommitte;

TYPE
        {gnrateur de composant meta}
        TMLGCompAggregating = class(TMLGenComp)
                          protected
                          procedure   GenCompInitializations(); override;
                          public
                          function    GetClassMLComponent: TClassMLComponent; override;
                          end;

        {le composant meta, singe un single learning}
        TMLCompAggregating = class(TMLCompMetaSpvLearning)
                         protected
                         function    ShortMLCompName(): string; override;
                         function    getClassOperator: TClassOperator; override;
                         end;

        {oprateur Aggregating}
        TOpMetaSpvAggregating = class(TOpMetaSpvCommitte)
                            protected
                            {simple tirage avec remise}
                            procedure   prepareSample(); override;    
                            end;    

implementation

uses
        Classes,
        UStringsResources;

{ TMLGCompAggregating }

procedure TMLGCompAggregating.GenCompInitializations;
begin
 FMLComp:= mlcMetaSpvLearning;
end;

function TMLGCompAggregating.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompAggregating;
end;

{ TMLCompAggregating }

function TMLCompAggregating.getClassOperator: TClassOperator;
begin
 result:= TOpMetaSpvAggregating;
end;

function TMLCompAggregating.ShortMLCompName: string;
begin
 result:= 'Aggregating';
end;

{ TOpMetaSpvAggregating }

procedure TOpMetaSpvAggregating.prepareSample;
begin
 self.WorkData.Examples.SampleReplicate(FInternalExamples);
end;

initialization
 RegisterClass(TMLGCompAggregating);
end.
