unit UDlgOpPrmSpvDLCN2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls,
  lmdstdcA;

type
  TdlgOprPrmSpvDLCN2 = class(TDlgBaseOperatorParameter)
    Label1: TLabel;
    cmbRuleEvaluation: TComboBox;
    Label2: TLabel;
    edSigLevel: TEdit;
    Label3: TLabel;
    spinMinSupport: TLMDSpinEdit;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  dlgOprPrmSpvDLCN2: TdlgOprPrmSpvDLCN2;

implementation

uses UCompSpvCN2, UCalcSpvCN2;

{$R *.dfm}

{ TdlgOprPrmSpvDLCN2 }

procedure TdlgOprPrmSpvDLCN2.ApplyModifications;
var prm: TOpPrmCN2;
begin
 prm:= OpPrm as TOpPrmCN2;
 //placer les valeurs
 prm.Measurement:= TEnumMeasureCN2(self.cmbRuleEvaluation.ItemIndex);
 prm.SupportMin:= self.spinMinSupport.Value;
 TRY
 prm.SignifLevel:= StrToFloat(self.edSigLevel.Text);
 EXCEPT
 END;
end;

procedure TdlgOprPrmSpvDLCN2.SetParameters;
var prm: TOpPrmCN2;
begin
 prm:= OpPrm as TOpPrmCN2;
 //placer les valeurs
 self.cmbRuleEvaluation.ItemIndex:= ord(prm.Measurement);
 self.edSigLevel.Text:= Format('%.6f',[prm.SignifLevel]);
 self.spinMinSupport.Value:= prm.SupportMin;
end;

end.
