(***************************************************************)
(* UCompSpvTreeC45.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(***************************************************************)

{
@abstract(dfinition du composant de calcul d'un arbre de dcision - algo C4.5)
@author(Ricco)
@created(25/12/2005)

Par rapport  ID3, essentiellement :
(1) gain ratio
(2) post-pruning avec l'erreur pessimiste
}
unit UCompSpvTreeC45;

interface

USES
        Forms, Classes, IniFiles,
        UCalcTreeStructureDefinition,
        UCompDefinition,
        UCompSpvLDefinition,
        UOperatorDefinition,
        UCompSpvTreeID3;

TYPE
        {gnrateur de composant C4.5}
        TMLGCompSpvTreeC45 = class(TMLGCompSpvTree)
                              public
                              function    GetClassMLComponent: TClassMLComponent; override;
                              end;

        {le composant SpvTree C4.5}
        TMLCompSpvTreeC45 = class(TMLCompSpvTree)
                             protected
                             function    getClassOperator: TClassOperator; override;
                             end;

        {l'oprateur C4.5}
        TOpSpvTreeC45 = class(TOpSpvTree)
                         protected
                         function    getClassParameter: TClassOperatorParameter; override;
                         function    getClassSpvLearning(): TClassCalcSpvLearning; override;
                         end;

        {paramtre de l'algo C4.5}
        TOpPrmSpvTreeC45 = class(TOpPrmSpvTree)
                            private
                            //effectif d'admissibilit -- 5 par dfaut
                            FSizeMinLeaf: integer;
                            //risque critique pour l'erreur pessimiste -- 0.25 par dfaut
                            FPLevel: double;
                            protected
                            procedure   SetDefaultParameters(); override;
                            function    CreateDlgParameters(): TForm; override;
                            public
                            function    getHTMLParameters(): string; override;
                            procedure   LoadFromStream(prmStream: TStream); override;
                            procedure   SaveToStream(prmStream: TStream); override;
                            procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                            procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                            property    SizeMinLeaf: integer read FSizeMinLeaf write FSizeMinLeaf;
                            property    PLevel: double read FPLevel write FPLevel;
                            end;

        {algo d'arbre de dcision supervise}
        TCalcSpvTreeC45 = class(TCalcSpvTree)
                           protected
                           function    getClassTreeStructureSpv(): TClassMLTreeStructure; override;
                           end;


implementation

uses
    Sysutils,
    UCalcSpvTreeC45, UConstConfiguration, UDlgOpPrmSpvTreeC45;

{ TMLGCompSpvTreeC45 }

function TMLGCompSpvTreeC45.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSpvTreeC45;
end;

{ TMLCompSpvTreeC45 }

function TMLCompSpvTreeC45.getClassOperator: TClassOperator;
begin
 result:= TOpSpvTreeC45;
end;

{ TOpSpvTreeC45 }

function TOpSpvTreeC45.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSpvTreeC45;
end;

function TOpSpvTreeC45.getClassSpvLearning: TClassCalcSpvLearning;
begin
 result:= TCalcSpvTreeC45; 
end;

{ TOpPrmSpvTreeC45 }

function TOpPrmSpvTreeC45.CreateDlgParameters: TForm;
begin
 result:= TdlgOpPrmSpvTreeC45.CreateFromOpPrm(self); 
end;

function TOpPrmSpvTreeC45.getHTMLParameters: string;
var s: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>Decision tree (C4.5) parameters</TH></TR>';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Min size of leaves</TD><TD align=right>%d</TD></TR>',[FSizeMinLeaf]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Confidence-level for pessimistic</TD><TD align=right>%.2f</TD></TR>',[FPLevel]);
 s:= s+'</table>';
 result:= s;
end;

procedure TOpPrmSpvTreeC45.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FSizeMinLeaf:= prmINI.ReadInteger(prmSection,'min_size_leaf',FSizeMinLeaf);
 FPLevel:= prmINI.ReadFloat(prmSection,'p_level',FPLevel);
end;

procedure TOpPrmSpvTreeC45.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FSizeMinLeaf,sizeof(FSizeMinLeaf));
 prmStream.ReadBuffer(FPLevel,sizeof(FPLevel));
end;

procedure TOpPrmSpvTreeC45.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'min_size_leaf',FSizeMinLeaf);
 prmINI.WriteFloat(prmSection,'p_level',FPLevel);
end;

procedure TOpPrmSpvTreeC45.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FSizeMinLeaf,sizeof(FSizeMinLeaf));
 prmStream.WriteBuffer(FPLevel,sizeof(FPLevel));
end;

procedure TOpPrmSpvTreeC45.SetDefaultParameters;
begin
 FSizeMinLeaf:= 5;
 FPLevel:= 0.25;
end;

{ TCalcSpvTreeC45 }

function TCalcSpvTreeC45.getClassTreeStructureSpv: TClassMLTreeStructure;
begin
 result:= TMLTreeStructureSpvC45;
end;

initialization
 RegisterClass(TMLGCompSpvTreeC45);
end.
