(*******************************************************************)
(* UDlgOpPrmSpvTreeID3.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*******************************************************************)

unit UDlgOpPrmSpvTreeID3;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, LMDCustomControl, LMDCustomPanel, LMDCustomBevelPanel,
  LMDBaseEdit, LMDCustomEdit, LMDCustomMaskEdit, LMDMaskEdit, lmdstdcA;

type
  TDlgOpPrmSpvTreeID3 = class(TDlgBaseOperatorParameter)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    spinSizeBefore: TLMDSpinEdit;
    spinSizeAfter: TLMDSpinEdit;
    SpinDepth: TLMDSpinEdit;
    edGainThresold: TLMDMaskEdit;
  private
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  DlgOpPrmSpvTreeID3: TDlgOpPrmSpvTreeID3;

implementation

uses UCompSpvTreeID3;

{$R *.dfm}

{ TDlgOpPrmSpvTreeID3 }

procedure TDlgOpPrmSpvTreeID3.ApplyModifications;
var prm: TOpPrmSpvTree;
begin
 prm:= OpPrm as TOpPrmSpvTree;
 prm.SetParameters(spinSizeBefore.Value,spinSizeAfter.Value,spinDepth.Value,edGainThresold.Text);
end;

procedure TDlgOpPrmSpvTreeID3.SetParameters;
var prm: TOpPrmSpvTree;
begin
 prm:= OpPrm as TOpPrmSpvTree;
 spinSizeBefore.Value:= prm.SizeBeforeSplit;
 spinSizeAfter.Value:= prm.SizeAfterSplit;
 spinDepth.Value:= prm.MaxDepth;
 edGainThresold.Text:= FormatFloat('0.0000',prm.GoodnessThresold);
end;

end.
