(***************************************************************)
(* UDlgOpPrmSpvKNN.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***************************************************************)

unit UDlgOpPrmSpvKNN;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, lmdstdcA;

type
  TDlgOpPrmSpvKNN = class(TDlgBaseOperatorParameter)
    Label1: TLabel;
    spinNeighbors: TLMDSpinEdit;
    rgContDist: TRadioGroup;
  private
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  DlgOpPrmSpvKNN: TDlgOpPrmSpvKNN;

implementation

uses UCompSpvKNN;

{$R *.dfm}

{ TDlgOpPrmSpvKNN }

procedure TDlgOpPrmSpvKNN.ApplyModifications;
var prm: TOpPrmSpvKNN;
begin
 prm:= OpPrm as TOpPrmSpvKNN;
 prm.NbNeighbour:= spinNeighbors.Value;
 prm.DistNormalization:= TEnumKNNDistNormalization(self.rgContDist.ItemIndex);
end;

procedure TDlgOpPrmSpvKNN.SetParameters;
var prm: TOpPrmSpvKNN;
begin
 prm:= OpPrm as TOpPrmSpvKNN;
 spinNeighbors.Value:= prm.NbNeighbour;
 self.rgContDist.ItemIndex:= ord(prm.DistNormalization);
end;

end.
