# Source configuration.
include ../Makefile.conf

# Per-executable configuration.
LIBS +=

SHELL := /bin/sh

# Internal.
depdirs := $(foreach d,$(DEPS),../$(d))
includes := $(foreach d,$(depdirs),-I$(d))

libs := $(foreach d,$(DEPS),../$(d)/lib$(d).a) $(LIBS)

headers := $(wildcard *.h)
csources := $(filter-out main.c, $(wildcard *.c))
objs := $(patsubst %.c,%.o,$(csources))


here := $(shell basename "$$(pwd)")
exe := $(here)
lib := lib$(here).a


# Executable, library, and objects.
.PHONY : exe lib
exe: $(exe)
$(exe): $(libs) $(lib) main.c
	$(CC) -o $@ $(includes) main.c $(lib) $(libs) $(LDFLAGS)

lib: $(lib)
$(lib): $(libs) $(objs)
	$(AR) rv "$(lib)" $(objs)

# .c to .o, need to condition on Windows or UNIX.
%.o : %.c $(headers)
ifeq ($(t),win32)
	$(CC) /nologo /c $(CFLAGS) $(includes) /Fo$@ $<
else
	$(CC) -c $(CFLAGS) $(includes) -o $@ $<
endif

# Clean.
.PHONY : clean cleanall
clean:
	$(RM) *.o *.obj gmon.out *~
	$(RM) $(lib)
	$(RM) $(exe)

cleanall: clean
	for d in $(depdirs); do make -C "$$d" clean; done



# Supporting libraries.
.PHONY : depdirs $(depdirs)
depdirs: $(depdirs)
$(depdirs):
	$(MAKE) -C $@

$(libs): $(depdirs)
