(**************************************************************)
(* UCalcSpvTrirls.pas - Copyright (c) 2006 Ricco RAKOTOMALALA *)
(**************************************************************)

{
@abstract(Utilisation de la mthode TRIRLS -( Rgression logistique)
@author(Ricco)
@created(18/02/2006)

La mthode est importe  partir d'une DLL.

}

unit UCalcSpvTrirls;

interface

USES
   UDatasetExamples,
   UCompSpvLDefinition,
   UDatasetDefinition,
   UCalcDistribution,
   UCalcSpvStructScore,
   //et trs important, l'unit d'import
   UImportTRIRLS;

TYPE
    TCalcSpvTrirls = class(TCalcSpvLearning)
    private
    //options
    FOptions: p_lr_options;
    //tableau de donnes intermdiaires
    FDescriptors: p_dym;
    //la sortie
    FOutput: p_dyv;
    //coefficients de prdiction
    FCoefficients: p_lr_predict;
    //mettre les paramtres par dfaut -- extrait "svm_train.c"
    procedure setDefaultParameters();
    //rcuprer les paramtres en provenance de Tanagra
    procedure getUserParameters();
    //lancer l'apprentissage -- private,  prparer au cas o il faut insrer qq chose au milieu
    function    runClassifier(examples: TExamples): boolean;
    protected
    procedure   destroyStructures(); override;
    public
    //surcharge normale dans la hirachie
    function    coreLearning(examples: TExamples): boolean; override;
    //prospective totale -- utiliser une fonction logistique sur la sortie
    procedure   getScore(example: integer; var postProba: TTabScore); override;
    //description des rsultats
    function    getHTMLResults(): string; override;
  end;

implementation

uses
    ULogFile, UConstConfiguration,
    Sysutils, Windows;

    { TCalcSpvTrirls }


function TCalcSpvTrirls.coreLearning(examples: TExamples): boolean;
begin
 //pas de souci a priori
 result:= self.runClassifier(examples);
end;

procedure TCalcSpvTrirls.destroyStructures;
begin
 if assigned(FOptions) then dispose(FOptions);
 if assigned(FDescriptors) then free_dym(FDescriptors);
 if assigned(FOutput) then free_dyv(FOutput);
end;

function TCalcSpvTrirls.getHTMLResults: string;
var s: string;
    j: integer;
begin
 s:= '<H3>TRIRLS characteristics</H3>';
 s:= s + HTML_HEADER_TABLE_RESULT;
 s:= s + HTML_TABLE_COLOR_HEADER_GRAY + '<TH>Attribute</TH><TH>Value</TH></TR>';
 s:= s + HTML_TABLE_COLOR_DATA_GRAY + format('<TD>%s</TD><TD align=right>%.4f</TD></TR>',['constant',FCoefficients^.b0]);
 for j:= 0 to pred(FCoefficients^.b[0].size) do
  s:= s + HTML_TABLE_COLOR_DATA_GRAY + format('<TD>%s</TD><TD align=right>%.4f</TD></TR>',[self.Descriptors.Attribute[j].Name,FCoefficients^.b[0].farr[j]]);
 s:= s + '</table>';
 //and then...
 result:= s;
end;

procedure TCalcSpvTrirls.getScore(example: integer;
  var postProba: TTabScore);
var v,proba: double;
    j: integer;
begin
 //calculer la proba P(Y=2/X)
 //combinaison linaire
 v:= FCoefficients^.b0;
 for j:= 1 to descriptors.Count do
  v:= v + FCoefficients^.b[0].farr[pred(j)]*descriptors.Attribute[pred(j)].cValue[example];
 //la proba
 proba:= 1.0/(1.0+exp(-v));
 //affecation
 postProba[0]:= 1.0;
 postProba[1]:= 1.0 - proba;
 postProba[2]:= proba;
end;

procedure TCalcSpvTrirls.getUserParameters;
begin
 //
end;

function TCalcSpvTrirls.runClassifier(examples: TExamples): boolean;
var i,j: integer;
    att: TAttribute;
    tps: cardinal;
begin
 //prparation
 self.destroyStructures();
 self.setDefaultParameters();
 self.getUserParameters();
 //******************
 //copier les donnes
 //******************
 //prparer la mmoire pour les descripteurs
 FDescriptors:= mk_dym(examples.Size,self.Descriptors.Count);
 //copier les descripteurs
 for j:= 0 to pred(self.Descriptors.Count) do
  begin
   att:= self.Descriptors.Attribute[j];
   for i:= 1 to examples.Size do
    FDescriptors^.tdarr[pred(i)][j]:= att.cValue[examples.Number[i]];
  end;
 //prparer la mmoire pour les output
 FOutput:= mk_dyv(examples.Size);
 //copier
 for i:= 1 to examples.Size do
  FOutput^.farr[pred(i)]:= 1.0*pred(self.ClassAttribute.dValue[examples.Number[i]]);//1 --> 0, et 2 --> 1
 //***********************
 //** lancer le traitement
 //***********************
 TRY
 tps:= GetTickCount();
 FCoefficients:= dense_mk_train_lr_predict(FDescriptors,FOutput,FOptions);
 tps:= getTickCount()-tps;
 TraceLog.WriteToLogFile(format('[TRIRLS] call dll func duration = %d ms.',[tps]));
 result:= true;
 EXCEPT
 result:= false;
 END;
end;

procedure TCalcSpvTrirls.setDefaultParameters;
begin
 new(FOptions);
 
 //* Options which are always available. */
 FOptions^.rrlambda   := 10.0;

 //*   Termination criteria for lr iterations. */
 FOptions^.lreps      := 0.05;
 FOptions^.lrmax      := 30;

 //* cg options are available in conjuagate gradient runs. */
 FOptions^.cgbinit    := 1;
 FOptions^.cgdeveps   := 0.005;    //* suggestion: 0.005 */
 FOptions^.cgeps      := 0.000;  //* multiplied by initial CG rsqr. */
 FOptions^.cgmax      := 200;

 FOptions^.cgwindow   := 3;      //* Number of bad iterations allowed. */
 FOptions^.cgdecay    := 1000.0; //* Factor worse than best-seen that is allowed. */

end;


end.
