(**************************************************************)
(* UCompSpvTrirls.pas - Copyright (c) 2006 Ricco RAKOTOMALALA *)
(**************************************************************)

{
@abstract(Utilisation de la rgression logistique de la bibliothque LR-TRIRLS)
@author(Ricco)
@created(18/02/2006)

}
unit UCompSpvTrirls;

interface

USES
       Classes, Forms, IniFiles,
       UCompDefinition,
       UCompSpvLDefinition,
       UOperatorDefinition,
       UDatasetImplementation;

TYPE
       TMLGCompSpvTRIRLS = class(TMLGenCompSpvLearning)
                         public
                         function    GetClassMLComponent: TClassMLComponent; override;
                         end;

       TMLCompSpvTRIRLS = class(TMLCompSpvLearning)
                        protected
                        function    getClassOperator: TClassOperator; override;
                        function    GetLogResultDescription(): string; override;
                        end;

       TOpSpvTRIRLS = class(TOpSpvLearningContinuous)
                    protected
                    function    getClassParameter: TClassOperatorParameter; override;
                    function    getClassSpvLearning(): TClassCalcSpvLearning; override;
                    function    ConnectDescriptors(prmData: TMLDataset): boolean; override;
                    end;

       TOpPrmTRIRLS = class(TOpPrmSpvLearning)
                    private
                    protected
                    function    CreateDlgParameters(): TForm; override;
                    procedure   SetDefaultParameters(); override;
                    public
                    function    getHTMLParameters(): string; override;
                    //I-O
                    (*
                    procedure   LoadFromStream(prmStream: TStream); override;
                    procedure   SaveToStream(prmStream: TStream); override;
                    procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                    procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                    *)
                    end;

implementation

uses
    Sysutils, UDatasetDefinition, UCalcSpvTrirls, UImportTRIRLS,
    UConstConfiguration;

{ TMLGCompSpvTRIRLS }

function TMLGCompSpvTRIRLS.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSpvTRIRLS;
end;

{ TMLCompSpvTRIRLS }

function TMLCompSpvTRIRLS.getClassOperator: TClassOperator;
begin
 result:= TOpSpvTRIRLS; 
end;

function TMLCompSpvTRIRLS.GetLogResultDescription: string;
begin
 result:= '[IRLS] from LR-TRIRLS generated';
end;

{ TOpSpvTRIRLS }

function TOpSpvTRIRLS.ConnectDescriptors(prmData: TMLDataset): boolean;
var ok: boolean;
begin
 //accepter les prdicteurs quasi-continus, i.e. continus ou discrets binaires
 ok:= (prmData.LstAtts[asInput].Count > 0) AND (prmData.LstAtts[asInput].isAllCategory(caQuasiContinue));
 if ok then FDescriptorsAtt:= prmData.LstAtts[asInput];//branchement direct, pas de recopie locale
 //a marche que pour le binaire
 ok:= ok and (self.ClassAttribute.nbValues = 2);
 //and then...
 result:= ok;
end;

function TOpSpvTRIRLS.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmTRIRLS;
end;

function TOpSpvTRIRLS.getClassSpvLearning: TClassCalcSpvLearning;
begin
 result:= TCalcSpvTrirls;
end;

{ TOpPrmTRIRLS }

function TOpPrmTRIRLS.CreateDlgParameters: TForm;
begin
 result:= nil;
end;

function TOpPrmTRIRLS.getHTMLParameters: string;
begin
 result:= '';
end;

procedure TOpPrmTRIRLS.SetDefaultParameters;
begin
 //
end;

initialization
 RegisterClass(TMLGCompSpvTRIRLS);
end.
