(*************************************************************)
(* UImportTRIRLS.pas - Copyright (c) 2006 Ricco RAKOTOMALALA *)
(*************************************************************)

{
@abstract(Unit d'importation de LR-TRIRLS)
@author(Ricco)
@created(18/02/2006)

Importation implicite des fonctions de la bibliothque LR-TRIRLS
(http://komarix.org/ac/lr)

Rgression logistique pour la discrimination (binaire).
Apparemment, particulirement efficace pour les donnes "sparse"

A ce jour (18/02/2006), on se cantonne uniquement aux structures "denses" (donnes normales).

}
unit UImportTRIRLS;

interface

TYPE

//options de calcul
lr_options = record
  rrlambda: double;
  lreps: double;
  lrmax: integer;

  cgdeveps: double;
  cgeps: double;
  cgmax: integer;
  cgbinit: integer;     //* Set automatically. */

  cgwindow: integer;    //* Number of bad iterations allowed. */
  cgdecay: double;      //* Factor worse than best-seen so far that is allowed. */
end;

//pointeur d'options de calcul
p_lr_options = ^lr_options;

//donnes "denses"
dym = record
  dym_code: integer;
  rows: integer;
  cols: integer;
  rows_allocated: integer;
  tdarr: array of array of double;
end;

//pointeur de donnes "denses"
p_dym = ^dym;

//colonne de donnes
dyv = record
  dyv_code: integer;
  array_size: integer;
  size: integer;
  farr: array of double;
end;

//pointeur de colonne de donnes
p_dyv = ^dyv;

//coefficients de prdiction
lr_predict = record
  b0: double;
  b: array of dyv;
end;

//pointeur de coefficients de prdiction
p_lr_predict = ^lr_predict;

//**************************************************
//************* FUNCTIONS **************************
//**************************************************

//apprentissage et prdiction
function dense_mk_train_lr_predict(factors: p_dym; outputs: p_dyv; opts: p_lr_options): p_lr_predict; stdcall; external '.\dll\trirls.dll';
function dense_mk_predicts(testfactors: p_dym; testout: p_dyv; lrp: p_lr_predict): p_dyv; stdcall; external '.\dll\trirls.dll';

//tableau de donnes
function mk_dym(nrows: integer; ncolumns: integer): p_dym; stdcall; external '.\dll\trirls.dll';
procedure free_dym(d: p_dym); stdcall; external '.\dll\trirls.dll';

//tableau des valeurs de Y
function mk_dyv(size: integer): p_dyv; stdcall; external '.\dll\trirls.dll';
procedure free_dyv(d: p_dyv); stdcall; external '.\dll\trirls.dll';

implementation

end.
