/*
  Logistic Regression using Truncated Iteratively Re-weighted Least Squares
  (includes several programs)
  Copyright (C) 2005  Paul Komarek

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  Author: Paul Komarek, komarek@cmu.edu
  Alternate contact: Andrew Moore, awm@cs.cmu.edu

*/


/*
   File:        kfoldssumm.h
   Author:      Paul Komarek
   Created:     Mon May 23 18:21:32 EDT 2005
   Description: Data structure to Keep track of per-fold information.

   Copyright 2005, The Auton Lab
*/



#ifndef KFOLDSUMM_H
#define KFOLDSUMM_H



#include <stdio.h>
#include "amiv.h"
#include "amdyv.h"



typedef struct kfoldsumm_struct {
  ivec *fold_to_time;     /* Time for each fold, in seconds. */
  ivec *row_to_foldnum;   /* For each row, stores the fold in which that */
                          /* row was in the testset. */
  dyv *row_to_predict;    /* Prediction for each row. */

  /* Stats, filled in after all runs. */
  double total_auc;
  dyv *fold_to_auc;
  ivec *roc_num_wrong; /* ROC curve x coords. */
  ivec *roc_num_right; /* ROC curve y coords. */
  double auc_mean;
  double auc_sdev;
  double time_mean;
  double time_sdev;

} kfoldsumm;

/* Basic data structure operations. */
kfoldsumm *mk_kfoldsumm( int numfolds, int numrows);
kfoldsumm *mk_copy_kfoldsumm( const kfoldsumm *kfs);
void fprintf_kfoldsumm( FILE *f, const char *pre, const kfoldsumm *kfs,
                        const char *post);
void free_kfoldsumm( kfoldsumm *kfs);

/* Simple setting operations. */
void kfoldsumm_set_fold_time( kfoldsumm *kfs, int fold, int seconds);
void kfoldsumm_set_subfoldnums( kfoldsumm *kfs, const ivec *subrows,
                                int foldnum);
void kfoldsumm_set_subpredicts( kfoldsumm *kfs, const ivec *subrows,
                                const dyv *subpredicts);


/* Statistics. */
void kfoldsumm_update_stats( kfoldsumm *kfs, ivec *outputs);
void fprintf_kfoldsumm_stats( FILE *f, const char *pre, const kfoldsumm *kfs);


/* Save kfoldsumm information to a file. */
void kfoldsumm_save_foldnums( const kfoldsumm *kfs, const char *savename);
void kfoldsumm_save_predictions( const kfoldsumm *kfs, const char *savename);
void kfoldsumm_save_roc( const kfoldsumm *kfs, const char *savename,
                         const char *datafname);



#endif /* KFOLDSUMM_H */
