/*
  Logistic Regression using Truncated Iteratively Re-weighted Least Squares
  (includes several programs)
  Copyright (C) 2005  Paul Komarek

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  Author: Paul Komarek, komarek@cmu.edu
  Alternate contact: Andrew Moore, awm@cs.cmu.edu

*/


/*
   File:        trainmain.c
   Author:      Paul Komarek
   Date:        Thu May 19 16:24:05 EDT 2005
   Copyright 2005, Auton Lab
*/

#include <time.h>
#include "ambs.h"
#include "predict.h"



int main(int argc,char *argv[])
{
  char *s;
  time_t starttime, stoptime;
  double elapsedtime;

  /* Check args to see if help is needed. */
  s = (argc < 2) ? "help" : argv[1];

  /* Set verbosity level. */
  Verbosity = int_from_args( "verbosity", argc, argv, 0);

  /* Unbuffers stdout, so stuff shows up in files immediately and in the
     right order. */
  setvbuf( stdout, NULL, _IONBF, 0);

  /* Mark start time. */
  starttime = time( NULL);
  if (Verbosity >= 1) {
    printf( "Starting time: %ld  %s", (long) starttime, ctime( &starttime));
  }

  /* Execute action. */
  predict_main(argc,argv);

  /* Mark ending time. */
  stoptime = time( NULL);
  if (Verbosity >= 1) {
    printf( "Ending time: %ld  %s", (long) stoptime, ctime( &stoptime));
  }

  /* Compute and print elapsed time. */
  elapsedtime = difftime( stoptime, starttime);
  if (Verbosity >= 1) {
    printf( "Elapsed (real) time: %g seconds\n", elapsedtime);
  }
    
  return 0;
}
