/*
  Logistic Regression using Truncated Iteratively Re-weighted Least Squares
  (includes several programs)
  Copyright (C) 2005  Paul Komarek

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  Author: Paul Komarek, komarek@cmu.edu
  Alternate contact: Andrew Moore, awm@cs.cmu.edu

*/


/*
   File:        predict.h
   Author:      Paul Komarek
   Created:     Thu May 19 16:32:25 EDT 2005
   Description: Restores trained classifier and makes predictions.

   Copyright 2003, The Auton Lab, CMU
*/



#ifndef PREDICT_H
#define PREDICT_H



#include "amdym.h"
#include "spardat.h"
#include "lr.h"

/**************************************************************************/
/* EXPORT                                                                 */
/**************************************************************************/

//rr -- 18/02/2006 -- exportation de la procdure de prdiction pour les donnes denses
__declspec(dllexport) dyv* __stdcall dense_mk_predicts(dym *testfactors, dyv *testout, lr_predict *lrp);

/**************************************************************************/
/* TEST                                                                   */
/**************************************************************************/
void predict_write_pout( const char *poutname, const dyv *predicts);
dyv *mk_predicts( spardat *testsp, dym *testfactors, dyv *testout, lr_predict *lrp);
void predict_main( int argc, char *argv[]);



#endif
