#!/bin/sh

# Remove first 7 lines from stdin.  Then keep all lines until a blank
# line appears.  This removes all extraneous info from gprof's flat
# call graph when called with -z.  Then grab the last column forlines
# with no calls (4th-6thcolumns empty).  Because the 4th-6th columns
# are empty, the last column will be the 4th.  This gives us just the
# functions names for uncalled functions.

# I wish I knew how to easily grab just the nth char from a line in a
# shell script.  Instead of checking for empty columns, we'll check
# for a very long space.

# This works with 2.15.92.0.2 when called with --no-graph (though it should
# work even without --no-graph).  gprof should be called with -c and -z,
# otherwise this script is likely to return nothing at all.

(for i in 1 2 3 4 5 6 7; do read line; done;   # Remove first 7 lines.
 while read line; do                       # Stop reading at blank line.
     if [ -z "$line" ]; then
         break
     else
         echo "$line"  # Must quote line, or else we loose spaces.
     fi
 done;) \
| fgrep '                       ' \
| awk '{ print $4 }' \
| while read line; do        # Skip lines that had blank functions (how?)
       if [ -z "$line" ]; then
           continue
       else
           echo $line
       fi
  done
