#!/bin/sh

# Remove first 5 lines from stdin.  Then keep all lines until a blank
# line appears.  This removes all extraneous info from gprof's flat
# call graph.  Then grab the seventh column, so we just get function
# names.

# This works with 2.15.92.0.2 when called with --no-graph (though it should
# work even without --no-graph).  Adding -c or -z will certainly mess up
# the gprof output in ways that mess up this script.

# For some reason, functions sometimes slip in which were never
# called, or for which there is no call data.  We'll use our "space
# technique" from stripcalled.sh to eliminate these.  Obviously, these
# scripts may not work perfectly given the odd input possibilities.

(for i in 1 2 3 4 5; do read line; done;   # Remove first 5 lines.
 while read line; do                       # Stop reading at blank line.
     if [ -z "$line" ]; then
         break
     else
         echo "$line"
     fi
 done;) \
| fgrep -v '                       ' \
| awk '{ print $7 }'
