#!/bin/sh

progdir="$1"
datafile="$2"
lrout="$3"
lrcorrect="$4"
if [ -z "$lrcorrect" ]; then
    echo
    echo -n "Usage: $0 <progdir> <datafile> <lrout_fname> "
    echo "<correct_predict_fname>,"
    echo
    echo "where"
    echo "  progdir is the location of the train and predict executables,"
    echo "  datafile is the path to the a-or-d datafile,"
    echo "  lrout_fname is the file containing the computed LR parameters,"
    echo "  correct_predict_fname contains the expected AUC."
    echo
    exit 1
fi

predict="$progdir"/predict

if [ ! -x "$predict" ]; then
    echo
    echo "Error: Program '$predict' does not exist, or is not executable"
    echo "(are the permissions set correctly?)"
    echo
    exit 1
fi

if [ ! -r "$datafile" -a ! -r $(echo $datafile | cut -d: -f1) ]; then
    echo
    echo "Error: Data file '$datafile' does not exist, or is not readable"
    echo
    exit 1
fi


run_predict_test() {
    if [ -n "$1" ]; then
        echo "$predict" in "$datafile" csv load "$lrout" '| grep AUC'
    else
        "$predict" in "$datafile" csv load "$lrout" | grep AUC
    fi
}

# Run test.
result=$(run_predict_test)
if [ $? != 0 ]; then
    echo "Predict error: unknown."
    echo "Command was:"
    echo -n "    "
    run_predict_test display
    exit 1
fi

if ! echo $result | diff - "$lrcorrect"; then \
    echo
    echo "Predict error: lr predictions appear incorrect for command"
    echo -n "    "
    run_predict_test display
    echo "It could be a small difference in compilers, kernels, libraries,"
    echo "cflags, etc.  Please check the result of test_predict.sh before"
    echo "concluding that something is very wrong.  You can also check"
    echo "the difference by hand between the correct output '$lrcorrect' and"
    echo "the computed output from the command shown above."
    echo
    echo "You might also look for errors printed just before this message"
    echo "(just before 'Predict error: ...')"
    echo
    echo "Note that the datafile should be a-or-d.csv, or a file with the"
    echo "same contents."
    echo
    exit 1
fi
