/*
  Logistic Regression using Truncated Iteratively Re-weighted Least Squares
  (includes several programs)
  Copyright (C) 2005  Paul Komarek

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  Author: Paul Komarek, komarek@cmu.edu
  Alternate contact: Andrew Moore, awm@cs.cmu.edu

*/


/*
   File:        train.h
   Author:      Paul Komarek
   Created:     Thu Jun 12 03:30:15 EDT 2003
   Description: Trains classifer and stores the result.

   Copyright 2003, The Auton Lab, CMU
*/



#ifndef TRAIN_H
#define TRAIN_H


#include "amdym.h"
#include "spardat.h"
#include "lr.h"

/**************************************************************************/
/* EXPORT                                                                 */
/**************************************************************************/

//rr -- 18/02/2006 -- exportation de la procdure d'apprentissage pour les donnes denses
__declspec(dllexport) lr_predict* __stdcall dense_mk_train_lr_predict(dym *factors, dyv *outputs, lr_options *opts);

/**************************************************************************/
/* TRAIN                                                                  */
/**************************************************************************/
lr_predict* mk_train_lr_predict( spardat *sp, dym *factors, dyv *outputs, lr_options *opts);
void train_main( int argc, char *argv[]);



#endif
